/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.services.impl;

import org.craftercms.commons.rest.RestClientUtils;
import org.craftercms.profile.api.PersistentLogin;
import org.craftercms.profile.api.Ticket;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.AuthenticationService;
import org.craftercms.profile.services.impl.AbstractProfileRestClientBase;
import org.springframework.util.MultiValueMap;

public class AuthenticationServiceRestClient
extends AbstractProfileRestClientBase
implements AuthenticationService {
    public Ticket authenticate(String tenantName, String username, String password) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"tenantName", (Object)tenantName, params);
        RestClientUtils.addValue((String)"username", (Object)username, params);
        RestClientUtils.addValue((String)"password", (Object)password, params);
        String url = this.getAbsoluteUrl("/api/1/authentication/authenticate");
        return this.doPostForObject(url, params, Ticket.class, new Object[0]);
    }

    public Ticket createTicket(String profileId) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"profileId", (Object)profileId, params);
        String url = this.getAbsoluteUrl("/api/1/authentication/ticket/create");
        return this.doPostForObject(url, params, Ticket.class, new Object[0]);
    }

    public Ticket getTicket(String ticketId) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/authentication/ticket/{id}");
        return this.doGetForObject(url, Ticket.class, ticketId);
    }

    public void invalidateTicket(String ticketId) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/authentication/ticket/{id}/invalidate");
        this.doPostForLocation(url, this.createBaseParams(), ticketId);
    }

    public PersistentLogin createPersistentLogin(String profileId) throws ProfileException {
        MultiValueMap<String, String> params = this.createBaseParams();
        RestClientUtils.addValue((String)"profileId", (Object)profileId, params);
        String url = this.getAbsoluteUrl("/api/1/authentication/persistent_login/create");
        return this.doPostForObject(url, params, PersistentLogin.class, new Object[0]);
    }

    public PersistentLogin getPersistentLogin(String loginId) throws ProfileException {
        String url = this.getAbsoluteUrlWithAccessTokenIdParam("/api/1/authentication/persistent_login/{id}");
        return this.doGetForObject(url, PersistentLogin.class, loginId);
    }

    public PersistentLogin refreshPersistentLoginToken(String loginId) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/authentication/persistent_login/{id}/refresh_token");
        return this.doPostForObject(url, this.createBaseParams(), PersistentLogin.class, loginId);
    }

    public void deletePersistentLogin(String loginId) throws ProfileException {
        String url = this.getAbsoluteUrl("/api/1/authentication/persistent_login/{id}/delete");
        this.doPostForLocation(url, this.createBaseParams(), loginId);
    }
}

