/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.services.impl;

import java.net.URI;
import org.craftercms.commons.rest.AbstractRestClientBase;
import org.craftercms.commons.rest.RestClientUtils;
import org.craftercms.commons.rest.RestServiceException;
import org.craftercms.profile.api.exceptions.ErrorCode;
import org.craftercms.profile.api.exceptions.ErrorDetails;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.exceptions.ProfileRestServiceException;
import org.craftercms.profile.services.impl.AccessTokenIdResolver;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractProfileRestClientBase
extends AbstractRestClientBase {
    protected AccessTokenIdResolver accessTokenIdResolver;

    @Required
    public void setAccessTokenIdResolver(AccessTokenIdResolver accessTokenIdResolver) {
        this.accessTokenIdResolver = accessTokenIdResolver;
    }

    protected String getAbsoluteUrlWithAccessTokenIdParam(String relativeUrl) {
        String absoluteUrl = this.getAbsoluteUrl(relativeUrl);
        String accessTokenId = this.accessTokenIdResolver.getAccessTokenId();
        if (accessTokenId != null) {
            if (absoluteUrl.contains("?")) {
                return absoluteUrl + "&" + "accessTokenId" + "=" + accessTokenId;
            }
            return absoluteUrl + "?" + "accessTokenId" + "=" + accessTokenId;
        }
        return absoluteUrl;
    }

    protected MultiValueMap<String, String> createBaseParams() {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        RestClientUtils.addValue((String)"accessTokenId", (Object)this.accessTokenIdResolver.getAccessTokenId(), (MultiValueMap)params);
        return params;
    }

    protected <T> T doPostForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) throws ProfileException {
        try {
            return (T)this.restTemplate.postForObject(url, request, responseType, uriVariables);
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected URI doPostForLocation(String url, Object request, Object ... uriVariables) throws ProfileException {
        try {
            return this.restTemplate.postForLocation(url, request, uriVariables);
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected <T> T doGetForObject(String url, Class<T> responseType, Object ... uriVariables) throws ProfileException {
        try {
            return (T)this.restTemplate.getForObject(url, responseType, uriVariables);
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected <T> T doGetForObject(URI url, Class<T> responseType) throws ProfileException {
        try {
            return (T)this.restTemplate.getForObject(url, responseType);
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected <T> T doGetForObject(String url, ParameterizedTypeReference<T> responseType, Object ... uriVariables) throws ProfileException {
        try {
            return (T)this.restTemplate.exchange(url, HttpMethod.GET, null, responseType, uriVariables).getBody();
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected <T> T doGetForObject(URI url, ParameterizedTypeReference<T> responseType) throws ProfileException {
        try {
            return (T)this.restTemplate.exchange(url, HttpMethod.GET, null, responseType).getBody();
        }
        catch (RestServiceException e) {
            this.handleRestServiceException(e);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return null;
    }

    protected void handleRestServiceException(RestServiceException e) throws ProfileException {
        if (e.getErrorDetails() instanceof ErrorDetails) {
            ErrorDetails errorDetails = (ErrorDetails)e.getErrorDetails();
            HttpStatus responseStatus = e.getResponseStatus();
            ErrorCode errorCode = errorDetails.getErrorCode();
            String message = errorDetails.getMessage();
            throw new ProfileRestServiceException(responseStatus, errorCode, message);
        }
        HttpStatus responseStatus = e.getResponseStatus();
        String message = e.getErrorDetails().toString();
        throw new ProfileRestServiceException(responseStatus, message);
    }

    protected void handleException(Exception e) throws ProfileException {
        throw new ProfileException(e.getMessage(), (Throwable)e);
    }
}

