/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.management.web.controllers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.security.exception.ActionDeniedException;
import org.craftercms.commons.security.permissions.PermissionEvaluator;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.SortOrder;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.profile.management.exceptions.InvalidRequestParameterException;
import org.craftercms.profile.management.exceptions.ResourceNotFoundException;
import org.craftercms.profile.management.security.permissions.Action;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/profile"})
public class ProfileController {
    public static final String BASE_URL_PROFILE = "/profile";
    public static final String PATH_VAR_ID = "id";
    public static final String URL_VIEW_PROFILE_LIST = "/list/view";
    public static final String URL_VIEW_NEW_PROFILE = "/new/view";
    public static final String URL_VIEW_PROFILE = "/view";
    public static final String URL_GET_PROFILE_COUNT = "/count";
    public static final String URL_GET_PROFILE_LIST = "/list";
    public static final String URL_GET_PROFILE = "/{id}";
    public static final String URL_CREATE_PROFILE = "/create";
    public static final String URL_UPDATE_PROFILE = "/update";
    public static final String URL_DELETE_PROFILE = "/{id}/delete";
    public static final String PARAM_TENANT_NAME = "tenantName";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SORT_BY = "sortBy";
    public static final String PARAM_SORT_ORDER = "sortOrder";
    public static final String PARAM_START = "start";
    public static final String PARAM_COUNT = "count";
    public static final String VIEW_PROFILE_LIST = "profile-list";
    public static final String VIEW_NEW_PROFILE = "new-profile";
    public static final String VIEW_PROFILE = "profile";
    public static final String MODEL_MESSAGE = "message";
    public static final String MSG_PROFILE_CREATED_FORMAT = "Profile '%s' created";
    public static final String MSG_PROFILE_UPDATED_FORMAT = "Profile '%s' updated";
    public static final String MSG_PROFILE_DELETED_FORMAT = "Profile '%s' deleted";
    public static final Pattern QUERY_PATTERN = Pattern.compile("\\w+");
    public static final String FINAL_QUERY_FORMAT = "{username: {$regex: '.*%s.*', $options: 'i'}}";
    private String verificationUrl;
    private ProfileService profileService;
    private PermissionEvaluator<Profile, String> tenantPermissionEvaluator;
    private PermissionEvaluator<Profile, Profile> profilePermissionEvaluator;

    public void setVerificationUrl(String verificationUrl) {
        this.verificationUrl = verificationUrl;
    }

    @Required
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Required
    public void setTenantPermissionEvaluator(PermissionEvaluator<Profile, String> tenantPermissionEvaluator) {
        this.tenantPermissionEvaluator = tenantPermissionEvaluator;
    }

    @Required
    public void setProfilePermissionEvaluator(PermissionEvaluator<Profile, Profile> profilePermissionEvaluator) {
        this.profilePermissionEvaluator = profilePermissionEvaluator;
    }

    @RequestMapping(value={"/list/view"}, method={RequestMethod.GET})
    public String viewProfileList() {
        return VIEW_PROFILE_LIST;
    }

    @RequestMapping(value={"/new/view"}, method={RequestMethod.GET})
    public String viewNewProfile() {
        return VIEW_NEW_PROFILE;
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewProfile() {
        return VIEW_PROFILE;
    }

    @RequestMapping(value={"/count"}, method={RequestMethod.GET})
    @ResponseBody
    public long getProfileCount(@RequestParam(value="tenantName", required=false) String tenantName, @RequestParam(value="query", required=false) String query) throws ProfileException {
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            tenantName = SecurityUtils.getCurrentProfile().getTenant();
        } else {
            this.checkIfAllowed(tenantName, Action.GET_PROFILE_COUNT);
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            if (QUERY_PATTERN.matcher(query).matches()) {
                query = String.format(FINAL_QUERY_FORMAT, query);
                return this.profileService.getProfileCountByQuery(tenantName, query);
            }
            throw new InvalidRequestParameterException("Parameter 'query' must match regex " + QUERY_PATTERN.pattern());
        }
        return this.profileService.getProfileCount(tenantName);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Profile> getProfileList(@RequestParam(value="tenantName", required=false) String tenantName, @RequestParam(value="query", required=false) String query, @RequestParam(value="sortBy", required=false) String sortBy, @RequestParam(value="sortOrder", required=false) SortOrder sortOrder, @RequestParam(value="start", required=false) Integer start, @RequestParam(value="count", required=false) Integer limit) throws ProfileException {
        if (StringUtils.isEmpty((CharSequence)tenantName)) {
            tenantName = SecurityUtils.getCurrentProfile().getTenant();
        } else {
            this.checkIfAllowed(tenantName, Action.GET_PROFILE_LIST);
        }
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            if (QUERY_PATTERN.matcher(query).matches()) {
                query = String.format(FINAL_QUERY_FORMAT, query);
                return this.profileService.getProfilesByQuery(tenantName, query, sortBy, sortOrder, start, limit, new String[0]);
            }
            throw new InvalidRequestParameterException("Parameter 'query' must match regex " + QUERY_PATTERN.pattern());
        }
        return this.profileService.getProfileRange(tenantName, sortBy, sortOrder, start, limit, new String[0]);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Profile getProfile(@PathVariable(value="id") String id) throws ProfileException {
        Profile profile = this.profileService.getProfile(id, new String[0]);
        if (profile != null) {
            this.checkIfAllowed(profile, Action.GET_PROFILE);
            return profile;
        }
        throw new ResourceNotFoundException("No profile found for ID '" + id + "'");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> createProfile(@RequestBody Profile profile) throws ProfileException {
        this.checkIfAllowed(profile, Action.CREATE_PROFILE);
        profile = this.profileService.createProfile(profile.getTenant(), profile.getUsername(), profile.getPassword(), profile.getEmail(), profile.isEnabled(), profile.getRoles(), profile.getAttributes(), this.verificationUrl);
        return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_PROFILE_CREATED_FORMAT, profile.getId()));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> updateProfile(@RequestBody Profile profile) throws ProfileException {
        String id = profile.getId().toString();
        Profile currentProfile = this.profileService.getProfile(id, new String[0]);
        if (currentProfile != null) {
            this.checkIfAllowed(currentProfile, Action.UPDATE_PROFILE);
            this.profileService.updateProfile(id, profile.getUsername(), profile.getPassword(), profile.getEmail(), Boolean.valueOf(profile.isEnabled()), profile.getRoles(), profile.getAttributes(), new String[]{"$none"});
            return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_PROFILE_UPDATED_FORMAT, id));
        }
        throw new ResourceNotFoundException("No profile found for ID '" + id + "'");
    }

    @RequestMapping(value={"/{id}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> deleteProfile(@PathVariable(value="id") String id) throws ProfileException {
        Profile profile = this.profileService.getProfile(id, new String[0]);
        if (profile != null) {
            this.checkIfAllowed(profile, Action.DELETE_PROFILE);
            this.profileService.deleteProfile(id);
            return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_PROFILE_DELETED_FORMAT, id));
        }
        throw new ResourceNotFoundException("No profile found for ID '" + id + "'");
    }

    private void checkIfAllowed(String tenant, Action action) throws ActionDeniedException {
        if (!this.tenantPermissionEvaluator.isAllowed((Object)tenant, action.toString())) {
            if (tenant != null) {
                throw new ActionDeniedException(action.toString(), (Object)tenant);
            }
            throw new ActionDeniedException(action.toString());
        }
    }

    private void checkIfAllowed(Profile profile, Action action) throws ActionDeniedException {
        if (!this.profilePermissionEvaluator.isAllowed((Object)profile, action.toString())) {
            if (profile != null) {
                throw new ActionDeniedException(action.toString(), (Object)profile);
            }
            throw new ActionDeniedException(action.toString());
        }
    }
}

