/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.management.web.controllers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.security.exception.ActionDeniedException;
import org.craftercms.commons.security.permissions.PermissionEvaluator;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.Tenant;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.TenantService;
import org.craftercms.profile.management.exceptions.ResourceNotFoundException;
import org.craftercms.profile.management.security.AuthorizationUtils;
import org.craftercms.profile.management.security.permissions.Action;
import org.craftercms.security.utils.SecurityUtils;
import org.craftercms.security.utils.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tenant"})
public class TenantController {
    public static final String BASE_URL_TENANT = "/tenant";
    public static final String PATH_VAR_NAME = "name";
    public static final String URL_VIEW_TENANT_LIST = "/list/view";
    public static final String URL_VIEW_NEW_TENANT = "/new/view";
    public static final String URL_VIEW_TENANT = "/view";
    public static final String URL_GET_TENANT_NAMES = "/names";
    public static final String URL_GET_TENANT = "/{name}";
    public static final String URL_CREATE_TENANT = "/create";
    public static final String URL_UPDATE_TENANT = "/update";
    public static final String URL_DELETE_TENANT = "/{name}/delete";
    public static final String VIEW_TENANT_LIST = "tenant-list";
    public static final String VIEW_TENANT = "tenant";
    public static final String MODEL_PAGE_HEADER = "pageHeader";
    public static final String MODEL_MESSAGE = "message";
    public static final String PAGE_HEADER_NEW = "New Tenant";
    public static final String PAGE_HEADER_UPDATE = "Update Tenant";
    public static final String MSG_TENANT_CREATED_FORMAT = "Tenant '%s' created";
    public static final String MSG_TENANT_UPDATED_FORMAT = "Tenant '%s' updated";
    public static final String MSG_TENANT_DELETED_FORMAT = "Tenant '%s' deleted";
    private TenantService tenantService;
    private PermissionEvaluator<Profile, String> tenantPermissionEvaluator;

    @Required
    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Required
    public void setTenantPermissionEvaluator(PermissionEvaluator<Profile, String> tenantPermissionEvaluator) {
        this.tenantPermissionEvaluator = tenantPermissionEvaluator;
    }

    @RequestMapping(value={"/list/view"}, method={RequestMethod.GET})
    public String viewTenantList() throws ProfileException {
        return VIEW_TENANT_LIST;
    }

    @RequestMapping(value={"/new/view"}, method={RequestMethod.GET})
    public ModelAndView viewNewTenant() throws ProfileException {
        return new ModelAndView(VIEW_TENANT, MODEL_PAGE_HEADER, (Object)PAGE_HEADER_NEW);
    }

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public ModelAndView viewTenant() throws ProfileException {
        return new ModelAndView(VIEW_TENANT, MODEL_PAGE_HEADER, (Object)PAGE_HEADER_UPDATE);
    }

    @RequestMapping(value={"/names"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getTenantNames() throws ProfileException {
        if (AuthorizationUtils.isSuperadmin(SecurityUtils.getCurrentProfile())) {
            return TenantUtils.getTenantNames((TenantService)this.tenantService);
        }
        return Collections.singletonList(SecurityUtils.getCurrentProfile().getTenant());
    }

    @RequestMapping(value={"/{name}"}, method={RequestMethod.GET})
    @ResponseBody
    public Tenant getTenant(@PathVariable(value="name") String name) throws ProfileException {
        this.checkIfAllowed(name, Action.GET_TENANT);
        Tenant tenant = this.tenantService.getTenant(name);
        if (tenant != null) {
            return tenant;
        }
        throw new ResourceNotFoundException("No tenant found with name '" + name + "'");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> createTenant(@RequestBody Tenant tenant) throws ProfileException {
        this.checkIfAllowed(null, Action.CREATE_TENANT);
        if (tenant.getAvailableRoles().contains("PROFILE_SUPERADMIN")) {
            throw new ActionDeniedException(Action.CREATE_TENANT.toString(), (Object)tenant.getName());
        }
        tenant = this.tenantService.createTenant(tenant);
        return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_TENANT_CREATED_FORMAT, tenant.getName()));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> updateTenant(@RequestBody Tenant tenant) throws ProfileException {
        String name = tenant.getName();
        this.checkIfAllowed(name, Action.UPDATE_TENANT);
        Tenant currentTenant = this.tenantService.getTenant(name);
        if (currentTenant != null) {
            if (!currentTenant.getAvailableRoles().contains("PROFILE_SUPERADMIN") && tenant.getAvailableRoles().contains("PROFILE_SUPERADMIN")) {
                throw new ActionDeniedException(Action.UPDATE_TENANT.toString(), (Object)name);
            }
            if (currentTenant.getAvailableRoles().contains("PROFILE_SUPERADMIN") && !tenant.getAvailableRoles().contains("PROFILE_SUPERADMIN")) {
                throw new ActionDeniedException(Action.UPDATE_TENANT.toString(), (Object)name);
            }
            this.tenantService.updateTenant(tenant);
            return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_TENANT_UPDATED_FORMAT, name));
        }
        throw new ResourceNotFoundException("No tenant found with name '" + name + "'");
    }

    @RequestMapping(value={"/{name}/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> deleteTenant(@PathVariable(value="name") String name) throws ProfileException {
        this.checkIfAllowed(name, Action.DELETE_TENANT);
        Tenant tenant = this.tenantService.getTenant(name);
        if (tenant != null) {
            this.tenantService.deleteTenant(name);
            return Collections.singletonMap(MODEL_MESSAGE, String.format(MSG_TENANT_DELETED_FORMAT, name));
        }
        throw new ResourceNotFoundException("No tenant found with name '" + name + "'");
    }

    private void checkIfAllowed(String tenant, Action action) throws ActionDeniedException {
        if (!this.tenantPermissionEvaluator.isAllowed((Object)tenant, action.toString())) {
            if (tenant != null) {
                throw new ActionDeniedException(action.toString(), (Object)tenant);
            }
            throw new ActionDeniedException(action.toString());
        }
    }
}

