/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.management.security.permissions;

import org.craftercms.commons.security.exception.PermissionException;
import org.craftercms.commons.security.permissions.Permission;
import org.craftercms.commons.security.permissions.PermissionResolver;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.management.security.AuthorizationUtils;
import org.craftercms.profile.management.security.permissions.ProfileAdminProfilePermission;
import org.craftercms.profile.management.security.permissions.SuperadminPermission;
import org.craftercms.profile.management.security.permissions.TenantAdminProfilePermission;

public class ProfilePermissionResolver
implements PermissionResolver<Profile, Profile> {
    public Permission getGlobalPermission(Profile currentUser) throws PermissionException {
        throw new UnsupportedOperationException();
    }

    public Permission getPermission(Profile currentUser, Profile profile) throws PermissionException {
        if (AuthorizationUtils.isSuperadmin(currentUser)) {
            return new SuperadminPermission();
        }
        if (AuthorizationUtils.isTenantAdmin(currentUser)) {
            return new TenantAdminProfilePermission(currentUser, profile);
        }
        return new ProfileAdminProfilePermission(currentUser, profile);
    }
}

