/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.profile.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.profile.api.AccessToken;
import org.craftercms.profile.api.TenantAction;
import org.craftercms.profile.api.TenantPermission;
import org.craftercms.profile.repositories.AccessTokenRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class AccessTokenManagerCli {
    private static final String CONTEXT_PATH = "crafter/profile/access-token-manager-cli-context.xml";
    private BufferedReader stdIn;
    private PrintWriter stdOut;
    private AccessTokenRepository repository;
    private ObjectMapper objectMapper;
    private Options options;
    private CommandLineParser cmdLineParser;

    public AccessTokenManagerCli(BufferedReader stdIn, PrintWriter stdOut, AccessTokenRepository repository, ObjectMapper objectMapper) {
        this.stdIn = stdIn;
        this.stdOut = stdOut;
        this.repository = repository;
        this.objectMapper = objectMapper;
        this.options = new Options();
        this.options.addOption("help", false, "Prints this message");
        this.options.addOption("add", false, "Adds a new access token");
        this.options.addOption("remove", true, "Removes the access token with the given ID");
        this.options.addOption("list", false, "Lists all access tokens, in JSON format");
        this.options.addOption("listpretty", false, "As list, but printed in pretty format");
        this.cmdLineParser = new BasicParser();
    }

    public void run(String ... args) {
        try {
            CommandLine cmd = this.cmdLineParser.parse(this.options, args);
            if (cmd.hasOption("add")) {
                this.addToken();
            } else if (cmd.hasOption("remove")) {
                String tokenId = cmd.getOptionValue("remove");
                if (tokenId != null) {
                    this.removeToken(tokenId);
                } else {
                    this.dieWithHelpInfo("ERROR: No token ID specified for remove option");
                }
            } else if (cmd.hasOption("list")) {
                this.printTokensAsJson(false);
            } else if (cmd.hasOption("listpretty")) {
                this.printTokensAsJson(true);
            } else if (cmd.hasOption("help")) {
                this.printHelp();
            } else {
                this.dieWithHelpInfo("ERROR: Unrecognized command line option");
            }
        }
        catch (ParseException e) {
            this.die("ERROR: Command line parsing failed", e);
        }
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.stdOut, 74, "java -jar access-token-manager.jar", null, this.options, 1, 3, null, true);
        this.stdOut.flush();
    }

    private void addToken() {
        AccessToken token = null;
        try {
            token = this.readAccessToken();
        }
        catch (IOException e) {
            this.die("ERROR: Unable to read from input", e);
        }
        try {
            this.repository.save(token);
            this.stdOut.println("New token created and saved to DB: " + token);
            this.stdOut.flush();
        }
        catch (MongoDataException e) {
            this.die("ERROR: Unable to save token " + token + " to DB", e);
        }
    }

    private void removeToken(String tokenId) {
        try {
            this.repository.removeById(tokenId);
            this.stdOut.println("Token with ID '" + tokenId + "' deleted from the DB");
            this.stdOut.flush();
        }
        catch (MongoDataException e) {
            this.die("ERROR: Unable to delete token with ID '" + tokenId + "' from DB", e);
        }
    }

    private void printTokensAsJson(boolean pretty) {
        try {
            Iterable tokens = this.repository.findAll();
            this.objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            String serializedTokens = pretty ? this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tokens) : this.objectMapper.writeValueAsString((Object)tokens);
            this.stdOut.println(serializedTokens);
            this.stdOut.flush();
        }
        catch (MongoDataException e) {
            this.die("ERROR: Unable to retrieve access tokens from DB", e);
        }
        catch (JsonProcessingException e) {
            this.die("ERROR: Unable to serialize access tokens as JSON", e);
        }
    }

    private AccessToken readAccessToken() throws IOException {
        String application = this.readLineCheckingForEmpty("Enter application name: ");
        Date expirationDate = this.readExpirationDate();
        List<TenantPermission> permissions = this.readTenantPermissions();
        AccessToken token = new AccessToken();
        token.setId(UUID.randomUUID().toString());
        token.setApplication(application);
        token.setExpiresOn(expirationDate);
        token.setTenantPermissions(permissions);
        return token;
    }

    private String readLineCheckingForEmpty(String prompt) throws IOException {
        String in = "";
        while (StringUtils.isEmpty((CharSequence)in)) {
            this.stdOut.print(prompt);
            this.stdOut.flush();
            in = this.stdIn.readLine();
            if (!StringUtils.isEmpty((CharSequence)in)) continue;
            this.stdOut.println("ERROR: No input received");
            this.stdOut.flush();
        }
        return in;
    }

    private Date readExpirationDate() throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        while (true) {
            String dateStr = this.readLineCheckingForEmpty("Enter the expiration date of the token (mm/dd/yy): ");
            try {
                return dateFormat.parse(dateStr);
            }
            catch (java.text.ParseException e) {
                this.stdOut.println("ERROR: Invalid date format (expected format is mm/dd/yy)");
                this.stdOut.flush();
                continue;
            }
            break;
        }
    }

    private List<TenantPermission> readTenantPermissions() throws IOException {
        String addPermission;
        ArrayList<TenantPermission> permissions = new ArrayList<TenantPermission>();
        this.stdOut.println("***** Enter tenant permissions *****");
        this.stdOut.flush();
        do {
            permissions.add(this.readPermission());
            this.stdOut.print("Add another permission (Y/n)? ");
            this.stdOut.flush();
            addPermission = this.stdIn.readLine();
            if (!StringUtils.isEmpty((CharSequence)addPermission)) continue;
            addPermission = "n";
        } while (addPermission.equalsIgnoreCase("y") || addPermission.equalsIgnoreCase("yes"));
        this.stdOut.println("***********************************");
        this.stdOut.flush();
        return permissions;
    }

    private TenantPermission readPermission() throws IOException {
        Object[] actions;
        String tenant;
        boolean validActions;
        do {
            tenant = this.readLineCheckingForEmpty("Enter tenant name (use * for any tenant): ");
            actions = this.readLineCheckingForEmpty("Enter allowed actions, separated by comma (valid actions are " + StringUtils.join((Object[])TenantAction.values(), (String)", ") + " or * for any action): ").split("\\s*,\\s*");
            validActions = true;
            if (ArrayUtils.contains((Object[])actions, (Object)"*")) continue;
            for (Object action : actions) {
                if (EnumUtils.isValidEnum(TenantAction.class, (String)action)) continue;
                this.stdOut.println("ERROR: Unrecognized tenant action '" + (String)action + "'");
                this.stdOut.flush();
                validActions = false;
            }
        } while (!validActions);
        TenantPermission permission = new TenantPermission(tenant);
        permission.setAllowedActions(new HashSet<Object>(Arrays.asList(actions)));
        return permission;
    }

    private void die(String message, Throwable e) {
        this.stdOut.println(message);
        this.stdOut.flush();
        e.printStackTrace(this.stdOut);
        System.exit(1);
    }

    private void dieWithHelpInfo(String message) {
        this.stdOut.println(message);
        this.stdOut.flush();
        this.printHelp();
        System.exit(1);
    }

    public static void main(String ... args) {
        ApplicationContext context = AccessTokenManagerCli.getApplicationContext();
        AccessTokenRepository repository = (AccessTokenRepository)context.getBean(AccessTokenRepository.class);
        ObjectMapper objectMapper = (ObjectMapper)context.getBean(ObjectMapper.class);
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter stdOut = new PrintWriter(System.out);
        AccessTokenManagerCli cli = new AccessTokenManagerCli(stdIn, stdOut, repository, objectMapper);
        cli.run(args);
    }

    public static ApplicationContext getApplicationContext() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(CONTEXT_PATH);
        return context;
    }
}

