/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.validators.impl;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.RegexUtils;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.validators.impl.BasicValidator;

public class StringValidator
extends BasicValidator<String> {
    protected boolean notEmpty = false;
    protected boolean notBlank = false;
    protected Integer minLength = 0;
    protected Integer maxLength = Integer.MAX_VALUE;
    protected String[] whitelistRegexes = new String[0];
    protected String[] blacklistRegexes = new String[0];
    protected boolean matchFullInput = true;

    public StringValidator(String targetKey) {
        super(targetKey);
    }

    public void setNotEmpty(boolean notEmpty) {
        this.notEmpty = notEmpty;
    }

    public void setNotBlank(boolean notBlank) {
        this.notBlank = notBlank;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setWhitelistRegexes(String[] whitelistRegexes) {
        this.whitelistRegexes = whitelistRegexes;
    }

    public void setBlacklistRegexes(String[] blacklistRegexes) {
        this.blacklistRegexes = blacklistRegexes;
    }

    public void setMatchFullInput(boolean matchFullInput) {
        this.matchFullInput = matchFullInput;
    }

    @Override
    public boolean validate(String target, ValidationResult result) {
        if (!super.validate(target, result)) {
            return false;
        }
        if (this.notEmpty && StringUtils.isEmpty((CharSequence)target)) {
            result.addError(this.targetKey, "validation.error.string.notEmpty", new Object[0]);
            return false;
        }
        if (this.notBlank && StringUtils.isBlank((CharSequence)target)) {
            result.addError(this.targetKey, "validation.error.string.notBlank", new Object[0]);
            return false;
        }
        if (this.minLength != null && target != null && target.length() < this.minLength) {
            result.addError(this.targetKey, "validation.error.string.minLength", this.minLength);
            return false;
        }
        if (this.maxLength != null && target != null && target.length() > this.maxLength) {
            result.addError(this.targetKey, "validation.error.string.maxLength", this.maxLength);
            return false;
        }
        if (target != null && !this.isWhitelistedAndNotBlacklisted(target)) {
            result.addError(this.targetKey, "validation.error.string.regexMatchingFailed", new Object[0]);
            return false;
        }
        return true;
    }

    protected boolean isWhitelistedAndNotBlacklisted(String target) {
        return !(!ArrayUtils.isEmpty((Object[])this.whitelistRegexes) && !RegexUtils.matchesAny((String)target, Arrays.asList(this.whitelistRegexes), (boolean)this.matchFullInput) || !ArrayUtils.isEmpty((Object[])this.blacklistRegexes) && RegexUtils.matchesAny((String)target, Arrays.asList(this.blacklistRegexes), (boolean)this.matchFullInput));
    }
}

