/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.validators.impl;

import org.craftercms.commons.validation.ErrorCodes;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.annotations.param.EsapiValidationType;
import org.craftercms.commons.validation.validators.impl.StringValidator;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Validator;
import org.owasp.esapi.errors.IntrusionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsapiValidator
extends StringValidator {
    private static final Logger logger = LoggerFactory.getLogger(EsapiValidator.class);
    private final Validator validator = ESAPI.validator();
    private EsapiValidationType type;

    public EsapiValidator(String targetKey) {
        super(targetKey);
    }

    @Override
    public boolean validate(String target, ValidationResult result) {
        return super.validate(target, result) && this.validateEsapi(target, result);
    }

    private boolean validateEsapi(String target, ValidationResult result) {
        boolean isValid = false;
        String esapiType = this.type.typeKey;
        try {
            isValid = this.validator.isValidInput(esapiType, target, esapiType, this.maxLength.intValue(), !this.notNull);
        }
        catch (IntrusionException e) {
            logger.warn("Potential attack attempt detected while validating input for param '{}'", (Object)this.targetKey, (Object)e);
        }
        if (!isValid) {
            result.addError(this.targetKey, ErrorCodes.getEsapiErrorMessageKey(esapiType), new Object[0]);
        }
        return isValid;
    }

    public void setEsapiType(EsapiValidationType type) {
        this.type = type;
    }
}

