/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.validators.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.commons.validation.annotations.param.EsapiValidatedParam;
import org.craftercms.commons.validation.annotations.param.ValidateDoubleParam;
import org.craftercms.commons.validation.annotations.param.ValidateIntegerParam;
import org.craftercms.commons.validation.annotations.param.ValidateLongParam;
import org.craftercms.commons.validation.annotations.param.ValidateNoTagsParam;
import org.craftercms.commons.validation.annotations.param.ValidateSecurePathParam;
import org.craftercms.commons.validation.annotations.param.ValidateStringParam;
import org.craftercms.commons.validation.validators.AnnotationBasedValidatorFactory;
import org.craftercms.commons.validation.validators.Validator;
import org.craftercms.commons.validation.validators.impl.DoubleParamValidatorFactory;
import org.craftercms.commons.validation.validators.impl.EsapiValidatorFactory;
import org.craftercms.commons.validation.validators.impl.IntegerParamValidatorFactory;
import org.craftercms.commons.validation.validators.impl.LongParamValidatorFactory;
import org.craftercms.commons.validation.validators.impl.NoTagsParamValidatorFactory;
import org.craftercms.commons.validation.validators.impl.SecurePathParamValidatorFactory;
import org.craftercms.commons.validation.validators.impl.StringParamValidatorFactory;

public class AnnotationBasedValidatorFactoryRegistry
implements AnnotationBasedValidatorFactory<Annotation, Object> {
    protected Map<Class<?>, AnnotationBasedValidatorFactory> registry = new HashMap();

    public AnnotationBasedValidatorFactoryRegistry() {
        this.registry.put(ValidateStringParam.class, new StringParamValidatorFactory());
        this.registry.put(ValidateIntegerParam.class, new IntegerParamValidatorFactory());
        this.registry.put(ValidateLongParam.class, new LongParamValidatorFactory());
        this.registry.put(ValidateDoubleParam.class, new DoubleParamValidatorFactory());
        this.registry.put(ValidateSecurePathParam.class, new SecurePathParamValidatorFactory());
        this.registry.put(ValidateNoTagsParam.class, new NoTagsParamValidatorFactory());
        this.registry.put(EsapiValidatedParam.class, new EsapiValidatorFactory());
    }

    public void setRegistry(Map<Class<?>, AnnotationBasedValidatorFactory> registry) {
        this.registry = registry;
    }

    @Override
    public Validator<Object> getValidator(Annotation annotation) {
        AnnotationBasedValidatorFactory validatorFactory = this.registry.get(annotation.annotationType());
        if (validatorFactory != null) {
            return validatorFactory.getValidator(annotation);
        }
        return null;
    }
}

