/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.validators.impl;

import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.validators.impl.BasicValidator;

public abstract class AbstractNumberValidator<T extends Number>
extends BasicValidator<T> {
    protected T minValue;
    protected T maxValue;

    public AbstractNumberValidator(String targetKey) {
        super(targetKey);
    }

    public void setMinValue(T minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean validate(T target, ValidationResult result) {
        if (!super.validate(target, result)) {
            return false;
        }
        if (target != null && this.isLessThanMinValue(target)) {
            result.addError(this.targetKey, "validation.error.number.minValue", new Object[0]);
            return false;
        }
        if (target != null && this.isGreaterThanMaxValue(target)) {
            result.addError(this.targetKey, "validation.error.number.maxValue", new Object[0]);
            return false;
        }
        return true;
    }

    protected abstract boolean isLessThanMinValue(T var1);

    protected abstract boolean isGreaterThanMaxValue(T var1);
}

