/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections4.MapUtils;
import org.craftercms.commons.validation.ValidationUtils;

public class ValidationResult {
    protected String message;
    protected ResourceBundle errorMessageBundle;
    protected Map<String, String> errors;

    public ValidationResult() {
        this("");
    }

    public ValidationResult(String message) {
        this(message, ValidationUtils.getDefaultErrorMessageBundle());
    }

    public ValidationResult(ResourceBundle errorMessageBundle) {
        this("", errorMessageBundle);
    }

    public ValidationResult(String message, ResourceBundle errorMessageBundle) {
        this.message = message;
        this.errorMessageBundle = errorMessageBundle;
        this.errors = new HashMap<String, String>();
    }

    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public boolean hasErrors() {
        return MapUtils.isNotEmpty(this.errors);
    }

    @JsonProperty(value="errors")
    public Map<String, String> getErrors() {
        return this.errors;
    }

    public void addError(String key, String errorCode, Object ... args) {
        this.errors.put(key, ValidationUtils.getErrorMessage(this.errorMessageBundle, errorCode, args));
    }
}

