/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.rest;

import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.craftercms.commons.rest.BaseRestExceptionHandlers;
import org.craftercms.commons.validation.ValidationException;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.ValidationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class ValidationAwareRestExceptionHandlers
extends BaseRestExceptionHandlers {
    protected ResourceBundle errorMessageBundle;

    public void setErrorMessageBundle(ResourceBundle errorMessageBundle) {
        this.errorMessageBundle = errorMessageBundle;
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Object> handleValidationException(ValidationException ex, WebRequest request) {
        return this.handleExceptionInternal(ex, ex.getResult(), new HttpHeaders(), HttpStatus.BAD_REQUEST, request);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest webRequest) {
        Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
        if (cause instanceof UnrecognizedPropertyException) {
            UnrecognizedPropertyException upe = (UnrecognizedPropertyException)cause;
            String field = upe.getPropertyName();
            ValidationResult result = new ValidationResult();
            result.addError(field, ValidationUtils.getErrorMessage(this.errorMessageBundle, "validation.error.rest.field.unrecognized", new Object[0]), new Object[0]);
            return this.handleExceptionInternal((Exception)ex, result, new HttpHeaders(), HttpStatus.BAD_REQUEST, webRequest);
        }
        String message = ValidationUtils.getErrorMessage(this.errorMessageBundle, "validation.error.invalidRequestBody", new Object[0]);
        return this.handleExceptionInternal((Exception)ex, message, new HttpHeaders(), HttpStatus.BAD_REQUEST, webRequest);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ValidationResult result = new ValidationResult();
        for (FieldError fieldError : ex.getBindingResult().getFieldErrors()) {
            result.addError(fieldError.getField(), ValidationUtils.getErrorMessage(this.errorMessageBundle, "validation.error.rest.field.missing", new Object[0]), new Object[0]);
        }
        return this.handleExceptionInternal((Exception)ex, result, new HttpHeaders(), HttpStatus.BAD_REQUEST, request);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleGeneralException(Exception ex, WebRequest webRequest) {
        Throwable cause = ex.getCause();
        if (cause instanceof ValidationException) {
            return this.handleValidationException((ValidationException)cause, webRequest);
        }
        return this.handleExceptionInternal(ex, ex.getMessage(), new HttpHeaders(), HttpStatus.INTERNAL_SERVER_ERROR, webRequest);
    }
}

