/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.validation.validators.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.craftercms.commons.aop.AopUtils;
import org.craftercms.commons.validation.ValidationResult;
import org.craftercms.commons.validation.ValidationRuntimeException;
import org.craftercms.commons.validation.ValidationUtils;
import org.craftercms.commons.validation.validators.AnnotationBasedValidatorFactory;
import org.craftercms.commons.validation.validators.Validator;
import org.springframework.beans.factory.annotation.Required;

@Aspect
public class ValidateParamsAspect {
    protected ResourceBundle errorMessageBundle;
    protected AnnotationBasedValidatorFactory<Annotation, Object> validatorFactory;

    public void setErrorMessageBundle(ResourceBundle errorMessageBundle) {
        this.errorMessageBundle = errorMessageBundle;
    }

    @Required
    public void setValidatorFactory(AnnotationBasedValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Before(value="@within(org.craftercms.commons.validation.annotations.param.ValidateParams) || @annotation(org.craftercms.commons.validation.annotations.param.ValidateParams)")
    public void doValidation(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Method method = AopUtils.getActualMethod((JoinPoint)joinPoint);
        Annotation[][] allParamAnnotations = method.getParameterAnnotations();
        ValidationResult result = new ValidationResult(this.errorMessageBundle);
        if (ArrayUtils.isNotEmpty((Object[])allParamAnnotations)) {
            for (int i = 0; i < args.length; ++i) {
                Annotation[] paramAnnotations;
                Object param = args[i];
                for (Annotation annotation : paramAnnotations = allParamAnnotations[i]) {
                    this.validateParam(annotation, param, result);
                }
            }
        }
        if (result.hasErrors()) {
            String methodStr = method.toGenericString();
            result.setMessage(ValidationUtils.getErrorMessage(this.errorMessageBundle, "validation.error.invalidMethodParams", methodStr));
            throw new ValidationRuntimeException(result);
        }
    }

    protected void validateParam(Annotation annotation, Object param, ValidationResult result) {
        Validator<Object> validator = this.validatorFactory.getValidator(annotation);
        if (validator != null) {
            validator.validate(param, result);
        }
    }
}

