/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.providers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.craftercms.commons.config.DisableClassLoadingConstructor;
import org.craftercms.commons.upgrade.impl.providers.AbstractFileVersionProvider;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlFileVersionProvider<T>
extends AbstractFileVersionProvider<T> {
    protected final Yaml yaml;

    public YamlFileVersionProvider() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        this.yaml = new Yaml((BaseConstructor)new DisableClassLoadingConstructor(), new Representer(), options);
    }

    protected Map<String, Object> loadFile(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            Map map = (Map)this.yaml.load(is);
            return map;
        }
    }

    @Override
    protected String readVersionFromFile(Path file) throws Exception {
        Map<String, Object> values = this.loadFile(file);
        return (String)values.get("version");
    }

    @Override
    protected void writeVersionToFile(Path file, String version) throws Exception {
        Map<String, Object> values = this.loadFile(file);
        values.put("version", version);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.yaml.dump(values, (Writer)writer);
        }
    }
}

