/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.providers;

import org.craftercms.commons.upgrade.VersionProvider;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractVersionProvider<T>
implements VersionProvider<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String defaultValue = "SKIP";

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public String getVersion(UpgradeContext<T> context) throws UpgradeException {
        this.logger.debug("Getting current version for {}", context);
        try {
            String currentValue = this.doGetVersion(context);
            this.logger.debug("Found version {} for {}", (Object)currentValue, context);
            if (StringUtils.isEmpty((Object)currentValue)) {
                currentValue = this.defaultValue;
            }
            return currentValue;
        }
        catch (Exception e) {
            throw new UpgradeException("Error getting current version for " + context, e);
        }
    }

    protected abstract String doGetVersion(UpgradeContext<T> var1) throws Exception;

    @Override
    public void setVersion(UpgradeContext<T> context, String version) throws UpgradeException {
        this.logger.debug("Updating current version for {} to {}", context, (Object)version);
        try {
            this.doSetVersion(context, version);
            this.logger.debug("Version successfully updated for {}", context);
        }
        catch (Exception e) {
            throw new UpgradeException("Error updating version for " + context, e);
        }
    }

    protected abstract void doSetVersion(UpgradeContext<T> var1, String var2) throws Exception;
}

