/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.providers;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.providers.AbstractVersionProvider;

public abstract class AbstractFileVersionProvider<T>
extends AbstractVersionProvider<T> {
    protected Path getFile(UpgradeContext<T> context) {
        T target = context.getTarget();
        if (target instanceof String) {
            return Paths.get((String)target, new String[0]);
        }
        if (target instanceof File) {
            return ((File)target).toPath();
        }
        if (target instanceof Path) {
            return (Path)target;
        }
        throw new IllegalArgumentException("Target can't be converted to Path: " + target);
    }

    @Override
    protected String doGetVersion(UpgradeContext<T> context) throws Exception {
        Path file = this.getFile(context);
        return this.readVersionFromFile(file);
    }

    @Override
    protected void doSetVersion(UpgradeContext<T> context, String version) throws Exception {
        Path file = this.getFile(context);
        this.writeVersionToFile(file, version);
    }

    protected abstract String readVersionFromFile(Path var1) throws Exception;

    protected abstract void writeVersionToFile(Path var1, String var2) throws Exception;
}

