/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.pipeline;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.UpgradePipeline;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class DefaultUpgradePipelineImpl<T>
implements UpgradePipeline<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUpgradePipelineImpl.class);
    protected final String name;
    protected boolean continueOnFailure = false;
    protected final List<UpgradeOperation<T>> operations;

    public DefaultUpgradePipelineImpl(String name, List<UpgradeOperation<T>> operations) {
        this.name = name;
        this.operations = operations;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(UpgradeContext<T> context) throws UpgradeException {
        if (this.isEmpty()) {
            logger.debug("Pipeline '{}' is empty, skipping execution", (Object)this.name);
            return;
        }
        StopWatch watch = new StopWatch("pipeline " + this.name);
        logger.info("============================================================");
        logger.info("Starting execution of upgrade pipeline: {}", (Object)this.name);
        for (UpgradeOperation<T> operation : this.operations) {
            String operationName = operation.getClass().getSimpleName();
            logger.info("------- Starting execution of operation {} -------", (Object)operationName);
            watch.start(operationName);
            try {
                operation.execute(context);
            }
            catch (UpgradeException e) {
                if (this.continueOnFailure) {
                    logger.error("Execution of operation {} failed", (Object)operationName, (Object)e);
                    continue;
                }
                throw e;
            }
            finally {
                watch.stop();
                logger.info("------- Execution of operation {} completed -------", (Object)operationName);
            }
        }
        logger.info("Execution of pipeline {} completed", (Object)this.name);
        logger.info("============================================================");
        if (logger.isTraceEnabled()) {
            logger.trace("Pipeline Duration:\n" + watch.prettyPrint());
        }
    }

    @Override
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.operations);
    }
}

