/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl.pipeline;

import com.vdurmont.semver4j.Semver;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.config.YamlConfiguration;
import org.craftercms.commons.upgrade.UpgradeOperation;
import org.craftercms.commons.upgrade.UpgradePipeline;
import org.craftercms.commons.upgrade.UpgradePipelineFactory;
import org.craftercms.commons.upgrade.VersionProvider;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.exception.UpgradeNotSupportedException;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.craftercms.commons.upgrade.impl.operations.UpdateVersionUpgradeOperation;
import org.craftercms.commons.upgrade.impl.pipeline.DefaultUpgradePipelineImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DefaultUpgradePipelineFactoryImpl<T>
implements UpgradePipelineFactory<T>,
ApplicationContextAware {
    public static final String DEFAULT_PIPELINE_PREFIX = "pipelines.";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final VersionProvider<T> versionProvider;
    protected final Resource configurationFile;
    protected String pipelinePrefix = "pipelines.";
    protected String pipelineName;
    protected boolean updateVersion = true;
    protected ApplicationContext applicationContext;

    public DefaultUpgradePipelineFactoryImpl(String pipelineName, Resource configurationFile, VersionProvider<T> versionProvider) {
        this.pipelineName = pipelineName;
        this.configurationFile = configurationFile;
        this.versionProvider = versionProvider;
    }

    public void setPipelinePrefix(String pipelinePrefix) {
        this.pipelinePrefix = pipelinePrefix;
    }

    public void setUpdateVersion(boolean updateVersion) {
        this.updateVersion = updateVersion;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected HierarchicalConfiguration loadUpgradeConfiguration() throws UpgradeException {
        YamlConfiguration configuration = new YamlConfiguration();
        try (InputStream is = this.configurationFile.getInputStream();){
            configuration.read(is);
        }
        catch (Exception e) {
            throw new UpgradeException("Error reading configuration file", e);
        }
        return configuration;
    }

    protected UpgradePipeline<T> createPipeline(String name, List<UpgradeOperation<T>> operations) {
        this.logger.debug("Creating pipeline instance for '{}'", (Object)name);
        return new DefaultUpgradePipelineImpl<T>(name, operations);
    }

    @Override
    public UpgradePipeline<T> getPipeline(UpgradeContext<T> context) throws UpgradeException, ConfigurationException {
        String pipelineRoot;
        this.logger.debug("Building pipeline for target '{}'", context);
        String currentVersion = this.versionProvider.getVersion(context);
        if ("SKIP".equals(currentVersion)) {
            return new DefaultUpgradePipelineImpl(this.pipelineName, Collections.emptyList());
        }
        LinkedList<UpgradeOperation<T>> operations = new LinkedList<UpgradeOperation<T>>();
        HierarchicalConfiguration config = this.loadUpgradeConfiguration();
        String requiredVersion = config.getString((pipelineRoot = this.pipelinePrefix + this.pipelineName) + ".requires");
        if (StringUtils.isNotEmpty((CharSequence)requiredVersion)) {
            this.logger.debug("Pipeline '{}' requires version '{}'", (Object)this.pipelineName, (Object)requiredVersion);
            Semver version = new Semver(currentVersion, Semver.SemverType.NPM).withClearedSuffixAndBuild();
            if (!version.satisfies(requiredVersion)) {
                throw new UpgradeNotSupportedException(String.format("Current version '%s' for '%s' cannot be upgraded automatically, requires '%s'", currentVersion, context, requiredVersion));
            }
            pipelineRoot = pipelineRoot + ".versions";
        }
        List pipeline = config.configurationsAt(pipelineRoot);
        String nextVersion = currentVersion;
        for (HierarchicalConfiguration release : pipeline) {
            String sourceVersion = release.getString("currentVersion");
            String targetVersion = release.getString("nextVersion");
            if (sourceVersion.equals(nextVersion)) {
                this.logger.debug("Adding version '{}' to pipeline '{}'", (Object)sourceVersion, (Object)this.pipelineName);
                List operationsConfig = release.configurationsAt("operations");
                for (HierarchicalConfiguration operationConfig : operationsConfig) {
                    UpgradeOperation operation = (UpgradeOperation)this.applicationContext.getBean(operationConfig.getString("type"), UpgradeOperation.class);
                    operation.init(sourceVersion, targetVersion, operationConfig);
                    operations.add(operation);
                }
                if (this.updateVersion) {
                    this.logger.debug("Adding upgrade version operation for '{}' to pipeline '{}'", (Object)targetVersion, (Object)this.pipelineName);
                    UpdateVersionUpgradeOperation<T> updateOp = new UpdateVersionUpgradeOperation<T>(this.versionProvider);
                    updateOp.init(sourceVersion, targetVersion, config);
                    operations.add(updateOp);
                } else {
                    this.logger.debug("Skipping upgrade version operation for pipeline '{}'", (Object)this.pipelineName);
                }
                nextVersion = targetVersion;
                continue;
            }
            this.logger.debug("Skipping version '{}' already applied", (Object)sourceVersion);
        }
        return this.createPipeline(this.pipelineName, operations);
    }
}

