/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.upgrade.impl;

import java.util.List;
import org.craftercms.commons.config.ConfigurationException;
import org.craftercms.commons.upgrade.UpgradeManager;
import org.craftercms.commons.upgrade.UpgradePipeline;
import org.craftercms.commons.upgrade.UpgradePipelineFactory;
import org.craftercms.commons.upgrade.exception.UpgradeException;
import org.craftercms.commons.upgrade.impl.UpgradeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractUpgradeManager<T>
implements UpgradeManager<T>,
ApplicationContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ApplicationContext applicationContext;
    protected boolean continueOnFailure = true;

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upgrade(T target) throws UpgradeException {
        this.logger.info("Starting upgrade for target '{}'", target);
        try {
            this.doUpgrade(this.createUpgradeContext(target));
        }
        catch (Exception e) {
            UpgradeException ex = new UpgradeException("Error during upgrade for target " + target, e);
            if (!this.continueOnFailure) {
                throw ex;
            }
            this.logger.error("Error during upgrade for target " + target, (Throwable)ex);
        }
        finally {
            this.logger.debug("Upgrade completed for target '{}'", target);
        }
    }

    @Override
    public void upgrade() throws UpgradeException {
        this.logger.info("Starting upgrade of all targets");
        List<T> targets = this.getTargets();
        for (T target : targets) {
            this.upgrade(target);
        }
    }

    @Override
    public List<T> getTargets() throws UpgradeException {
        this.logger.debug("Collecting target names");
        try {
            return this.doGetTargets();
        }
        catch (Exception e) {
            throw new UpgradeException("Error collecting target names", e);
        }
    }

    protected abstract List<T> doGetTargets() throws Exception;

    protected abstract UpgradeContext<T> createUpgradeContext(T var1);

    protected abstract void doUpgrade(UpgradeContext<T> var1) throws Exception;

    protected void executePipeline(UpgradeContext<T> context, UpgradePipelineFactory<T> pipelineFactory) throws ConfigurationException, UpgradeException {
        UpgradePipeline<T> pipeline = pipelineFactory.getPipeline(context);
        pipeline.execute(context);
    }
}

