/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.manager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Defines general license file validations and notifies listeners.
 *
 * @author joseross
 */
public interface LicenseManager {

    String LOG_PREFIX = "*** LICENSING ***";

    /**
     * Provides a single logger for all licensing related classes.
     * @return the logger
     */
    static Logger getLogger() {
        return LoggerFactory.getLogger(LOG_PREFIX);
    }

    /**
     * Checks if the license file has changes and is valid.
     */
    void loadLicense();

}
