/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.usage;

import java.util.Objects;

/**
 * Holds the configuration used by a {@link org.craftercms.commons.entitlements.usage.EntitlementUsageSender}.
 *
 * @author joseross
 */
public class UsageSenderConfiguration {

    /**
     * Indicates if the sender should be enabled or not.
     */
    protected boolean enabled;

    /**
     * The domain of the server to send the data.
     */
    protected String domain;

    /**
     * The UDP port to send the data.
     */
    protected int port;

    /**
     * The cron expression used to configure the schedule task.
     */
    protected String cron;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.enabled = enabled;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(final String domain) {
        this.domain = domain;
    }

    public int getPort() {
        return port;
    }

    public void setPort(final int port) {
        this.port = port;
    }

    public String getCron() {
        return cron;
    }

    public void setCron(final String cron) {
        this.cron = cron;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UsageSenderConfiguration)) {
            return false;
        }
        final UsageSenderConfiguration that = (UsageSenderConfiguration)o;
        return enabled == that.enabled && port == that.port && Objects.equals(domain, that.domain) &&
            Objects.equals(cron, that.cron);
    }

    @Override
    public int hashCode() {
        return Objects.hash(enabled, domain, port, cron);
    }

    @Override
    public String toString() {
        return "UsageSenderConfiguration{" + "enabled=" + enabled + ", domain='" + domain + '\'' + ", port=" + port +
            ", cron='" + cron + '\'' + '}';
    }

}
