/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.usage;

/**
 * Defines the operations for sending entitlement usage data.
 *
 * @author joseross
 */
public interface EntitlementUsageSender {

    /**
     * Collects the required data.
     * @return object holding the data
     * @throws Exception if there is an error collecting the data
     */
    EntitlementUsage prepareUsageData() throws Exception;

    /**
     * Sends the data to be recorded.
     */
    void sendData();

}
