/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.usage;

import java.time.Instant;
import java.util.List;

import org.craftercms.commons.entitlements.model.Entitlement;
import org.craftercms.commons.entitlements.model.Module;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * Holds the entitlement usage information for a given module.
 *
 * @author joseross
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class EntitlementUsage {

    /**
     * Id of the validator being used.
     */
    protected long validatorId;

    /**
     * Id of owner of the validator being used.
     */
    protected long clientId;

    /**
     * Id of the host running the validator.
     */
    protected String hostId;

    /**
     * Version of the validator being used.
     */
    protected String validatorVersion;

    /**
     * Module that is using the validator.
     */
    protected Module module;

    /**
     * Version of the module that is using the validator.
     */
    protected String moduleVersion;

    /**
     * Build of the module that is using the validator.
     */
    protected String moduleBuild;

    /**
     * Name of the Operating System of the machine using the validator.
     */
    protected String osName;

    /**
     * Version of the Operating System of the machine using the validator.
     */
    protected String osVersion;

    /**
     * Architecture of the Operating System of the machine using the validator.
     */
    protected String osArch;

    /**
     *  Date when the module using the validator was started.
     */
    protected Instant startupDate;

    /**
     * Amount of milliseconds that the module using the validator has been running.
     */
    protected long runDuration;

    /**
     * Number of cores available to the JVM.
     */
    protected long cores;

    /**
     * Total amount of RAM available to the JVM.
     */
    protected long totalJvmMemory;

    /**
     * Remaining amount of RAM available to the JVM.
     */
    protected long freeJvmMemory;

    /**
     * Total amount of physical memory.
     */
    protected long totalPhysicalMemory;

    /**
     * Remaining amount of physical memory.
     */
    protected long freePhysicalMemory;

    /**
     * Total amount of swap space.
     */
    protected long totalSwapMemory;

    /**
     * Remaining amount of swap space.
     */
    protected long freeSwapMemory;

    /**
     * List of network interfaces.
     */
    protected List<NetworkInterface> networkInterfaces;

    /**
     * Current usage of all entitlements supported by the module using the validator.
     */
    protected List<Entitlement> entitlements;

    /**
     * Additional data provided by the validator.
     */
    protected byte[] additionalData;

    /**
     * Date when the usage data was recorded.
     */
    protected Instant lastUpdate;

    public long getValidatorId() {
        return validatorId;
    }

    public void setValidatorId(long validatorId) {
        this.validatorId = validatorId;
    }

    public long getClientId() {
        return clientId;
    }

    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    public String getHostId() {
        return hostId;
    }

    public void setHostId(final String hostId) {
        this.hostId = hostId;
    }

    public String getValidatorVersion() {
        return validatorVersion;
    }

    public void setValidatorVersion(final String validatorVersion) {
        this.validatorVersion = validatorVersion;
    }

    public Module getModule() {
        return module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public String getModuleVersion() {
        return moduleVersion;
    }

    public void setModuleVersion(final String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public String getModuleBuild() {
        return moduleBuild;
    }

    public void setModuleBuild(final String moduleBuild) {
        this.moduleBuild = moduleBuild;
    }

    public String getOsName() {
        return osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getOsVersion() {
        return osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getOsArch() {
        return osArch;
    }

    public void setOsArch(final String osArch) {
        this.osArch = osArch;
    }

    public Instant getStartupDate() {
        return startupDate;
    }

    public void setStartupDate(Instant startupDate) {
        this.startupDate = startupDate;
    }

    public long getRunDuration() {
        return runDuration;
    }

    public void setRunDuration(long runDuration) {
        this.runDuration = runDuration;
    }

    public long getCores() {
        return cores;
    }

    public void setCores(final long cores) {
        this.cores = cores;
    }

    public long getTotalJvmMemory() {
        return totalJvmMemory;
    }

    public void setTotalJvmMemory(final long totalJvmMemory) {
        this.totalJvmMemory = totalJvmMemory;
    }

    public long getFreeJvmMemory() {
        return freeJvmMemory;
    }

    public void setFreeJvmMemory(final long freeJvmMemory) {
        this.freeJvmMemory = freeJvmMemory;
    }

    public long getTotalPhysicalMemory() {
        return totalPhysicalMemory;
    }

    public void setTotalPhysicalMemory(final long totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
    }

    public long getFreePhysicalMemory() {
        return freePhysicalMemory;
    }

    public void setFreePhysicalMemory(final long freePhysicalMemory) {
        this.freePhysicalMemory = freePhysicalMemory;
    }

    public long getTotalSwapMemory() {
        return totalSwapMemory;
    }

    public void setTotalSwapMemory(final long totalSwapMemory) {
        this.totalSwapMemory = totalSwapMemory;
    }

    public long getFreeSwapMemory() {
        return freeSwapMemory;
    }

    public void setFreeSwapMemory(final long freeSwapMemory) {
        this.freeSwapMemory = freeSwapMemory;
    }

    public List<NetworkInterface> getNetworkInterfaces() {
        return networkInterfaces;
    }

    public void setNetworkInterfaces(final List<NetworkInterface> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    public List<Entitlement> getEntitlements() {
        return entitlements;
    }

    public void setEntitlements(final List<Entitlement> entitlements) {
        this.entitlements = entitlements;
    }

    public byte[] getAdditionalData() {
        return additionalData;
    }

    public void setAdditionalData(final byte[] additionalData) {
        this.additionalData = additionalData;
    }

    public Instant getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(Instant lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    /**
     * Holds the information about a network interface.
     * @author joseross
     */
    public static class NetworkInterface {

        /**
         * Name of the interface.
         */
        protected String name;

        /**
         * IP address of the interface.
         */
        protected String ipAddress;

        /**
         * Hardware address of the interface.
         */
        protected String hardwareAddress;

        /**
         * Hostname of the interface.
         */
        protected String hostname;

        public String getName() {
            return name;
        }

        public void setName(final String name) {
            this.name = name;
        }

        public String getIpAddress() {
            return ipAddress;
        }

        public void setIpAddress(final String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public String getHardwareAddress() {
            return hardwareAddress;
        }

        public void setHardwareAddress(final String hardwareAddress) {
            this.hardwareAddress = hardwareAddress;
        }

        public String getHostname() {
            return hostname;
        }

        public void setHostname(final String hostname) {
            this.hostname = hostname;
        }

    }

}
