/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.exception;

/**
 * Exception thrown when the license file is corrupted or can't be decrypted.
 * This exception should prevent the startup of any module.
 *
 * @author joseross
 */
public class InvalidLicenseException extends EntitlementException {

    public InvalidLicenseException(final String message) {
        super(message);
    }

    public InvalidLicenseException(final String message, final Throwable cause) {
        super(message, cause);
    }

}
