/*
 * Copyright (C) 2007-2019 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.craftercms.commons.entitlements.usage;

import java.util.List;

import org.craftercms.commons.entitlements.model.Entitlement;
import org.craftercms.commons.entitlements.model.Module;

/**
 * Defines the operations to support entitlement usage data in a module.
 *
 * Each module must provide an implementation of this interface.
 *
 * @author joseross
 */
public interface EntitlementUsageProvider {

    /**
     * Identifies the current module running.
     * @return value from {@link Module}
     */
    Module getModule();

    /**
     * Provides an list holding the current values for all entitlements supported by the current module.
     * @return the entitlement list
     */
    List<Entitlement> getCurrentUsage();

}
