/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.manager;

import org.craftercms.commons.entitlements.exception.EntitlementException;
import org.slf4j.Logger;
import org.springframework.context.ApplicationListener;

/**
 * Defines the basic operations that all license related classes should provide.
 *
 * @author joseross
 */
public interface LicenseAware extends ApplicationListener<LicenseUpdatedEvent> {

    Logger logger = LicenseManager.LOGGER;

    /**
     * Performs all actions required when the license is updated.
     */
    void reloadLicense();

    /**
     * Reads the license file and extracts the relevant data.
     * @throws EntitlementException if there is any error reading the license file
     */
    void loadLicense() throws EntitlementException;

    /**
     * Handles the license update event
     * @param event the event
     */
    void onApplicationEvent(LicenseUpdatedEvent event);

}
