/*
 * Copyright (C) 2007-2018 Crafter Software Corporation. All Rights Reserved.
 *
 * This program is licensed under the Crafter Enterprise Software License Agreement, and its use is strictly limited
 * to operation with Crafter CMS Enterprise Edition. Unauthorized use, distribution, or modification is strictly
 * prohibited.
 *
 */

package org.craftercms.commons.entitlements.exception;

import java.util.Date;

/**
 * Exception thrown when the license is of type {@code STANDARD} and the
 * end date has been reached.
 *
 * @author joseross
 */
public class ExpiredLicenseException extends EntitlementException {

    /**
     * The date when the license expired.
     */
    protected Date expireDate;

    public ExpiredLicenseException(Date expireDate) {
        super("The current license expired on " + expireDate);
        this.expireDate = expireDate;
    }

    public Date getExpireDate() {
        return expireDate;
    }

}
