/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.commons.api.documentation;

import com.google.common.collect.Ordering;
import com.mangofactory.swagger.configuration.SpringSwaggerConfig;
import com.mangofactory.swagger.ordering.ResourceListingPositionalOrdering;
import com.mangofactory.swagger.plugin.EnableSwagger;
import com.mangofactory.swagger.plugin.SwaggerSpringMvcPlugin;
import com.wordnik.swagger.model.ApiInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableSwagger
public class ApiDocumentationSwaggerConfiguration {
    private SpringSwaggerConfig springSwaggerConfig;
    @Value(value="#{'${swaggerSpringMvcPlugin.includePatterns}'.split(',')}")
    private List<String> includePatterns;
    @Value(value="${swagger.apiTitle}")
    private String apiTitle;
    @Value(value="${swagger.apiDescription}")
    private String apiDescription;
    @Value(value="${swagger.apiTermsOfServiceUrl}")
    private String apiTermsOfServiceUrl;
    @Value(value="${swagger.apiContactEmail}")
    private String apiContactEmail;
    @Value(value="${swagger.apiLicenceType}")
    private String apiLicenceType;
    @Value(value="${swagger.apiLicenceUrl}")
    private String apiLicenceUrl;
    @Value(value="${swagger.enablePositionalOrdering}")
    private boolean enablePositionalOrdering;

    @Autowired
    public void setSpringSwaggerConfig(SpringSwaggerConfig springSwaggerConfig) {
        this.springSwaggerConfig = springSwaggerConfig;
    }

    @Bean
    public SwaggerSpringMvcPlugin customSwaggerSpringMvcPlugin() {
        SwaggerSpringMvcPlugin plugin = new SwaggerSpringMvcPlugin(this.springSwaggerConfig);
        plugin = plugin.apiInfo(this.apiInfo());
        plugin = plugin.includePatterns(this.includePatterns.toArray(new String[this.includePatterns.size()]));
        if (this.enablePositionalOrdering) {
            plugin = plugin.apiListingReferenceOrdering((Ordering)new ResourceListingPositionalOrdering());
        }
        plugin = plugin.build();
        return plugin;
    }

    private ApiInfo apiInfo() {
        ApiInfo apiInfo = new ApiInfo(this.apiTitle, this.apiDescription, this.apiTermsOfServiceUrl, this.apiContactEmail, this.apiLicenceType, this.apiLicenceUrl);
        return apiInfo;
    }
}

