/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.siemens.internal.handler;

import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.s7.connection.S7PlcConnection;
import org.connectorio.binding.plc4x.shared.handler.SharedPlc4xBridgeHandler;
import org.connectorio.binding.plc4x.siemens.internal.SiemensBindingConstants;
import org.connectorio.binding.plc4x.siemens.internal.config.SiemensNetworkConfiguration;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiemensNetworkBridgeHandler
extends SharedPlc4xBridgeHandler<S7PlcConnection, SiemensNetworkConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(SiemensNetworkBridgeHandler.class);
    private CompletableFuture<S7PlcConnection> initializer;

    public SiemensNetworkBridgeHandler(Bridge thing) {
        super(thing);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        this.updateStatus(ThingStatus.UNKNOWN);
        this.initializer = new CompletableFuture();
        Runnable connectionTask = new Runnable(){

            @Override
            public void run() {
                try {
                    SiemensNetworkConfiguration config = (SiemensNetworkConfiguration)((Object)SiemensNetworkBridgeHandler.this.getBridgeConfig().get());
                    S7PlcConnection connection = (S7PlcConnection)new PlcDriverManager(this.getClass().getClassLoader()).getConnection("s7://" + config.host + "/" + config.rack + "/" + config.slot);
                    connection.connect();
                    if (connection.isConnected()) {
                        SiemensNetworkBridgeHandler.this.updateStatus(ThingStatus.ONLINE);
                        SiemensNetworkBridgeHandler.this.initializer.complete(connection);
                    } else {
                        SiemensNetworkBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Connection failed");
                        SiemensNetworkBridgeHandler.this.initializer.complete(null);
                    }
                }
                catch (PlcConnectionException e) {
                    SiemensNetworkBridgeHandler.this.logger.warn("Could not obtain connection", (Throwable)e);
                    SiemensNetworkBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
                    SiemensNetworkBridgeHandler.this.initializer.completeExceptionally(e);
                }
            }
        };
        this.scheduler.submit(connectionTask);
    }

    public CompletableFuture<S7PlcConnection> getInitializer() {
        return this.initializer;
    }

    public S7PlcConnection getConnection() {
        return this.initializer.getNow(null);
    }

    protected Long getDefaultPollingInterval() {
        return SiemensBindingConstants.DEFAULT_REFRESH_INTERVAL;
    }
}

