/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.siemens.internal.handler;

import org.connectorio.binding.plc4x.shared.Plc4xHandlerFactory;
import org.connectorio.binding.plc4x.siemens.internal.SiemensBindingConstants;
import org.connectorio.binding.plc4x.siemens.internal.handler.SiemensNetworkBridgeHandler;
import org.connectorio.binding.plc4x.siemens.internal.handler.SiemensPlcHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"binding.siemens"}, service={ThingHandlerFactory.class})
public class SiemensHandlerFactory
extends Plc4xHandlerFactory {
    public SiemensHandlerFactory() {
        super(new ThingTypeUID[]{SiemensBindingConstants.THING_TYPE_TCP_IP, SiemensBindingConstants.THING_TYPE_S7});
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (SiemensBindingConstants.THING_TYPE_TCP_IP.equals((Object)thingTypeUID)) {
            return new SiemensNetworkBridgeHandler((Bridge)thing);
        }
        if (SiemensBindingConstants.THING_TYPE_S7.equals((Object)thingTypeUID)) {
            return new SiemensPlcHandler(thing);
        }
        return null;
    }
}

