/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.shared.handler.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.connectorio.binding.plc4x.shared.config.CommonChannelConfiguration;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(WriteTask.class);
    private final PlcWriteRequest request;
    private final Channel channel;
    private final CommonChannelConfiguration channelConfig;

    public WriteTask(PlcConnection connection, Channel channel, Command value) {
        this.channel = channel;
        this.channelConfig = (CommonChannelConfiguration)((Object)channel.getConfiguration().as(CommonChannelConfiguration.class));
        this.request = connection.writeRequestBuilder().addItem(this.getUID(), this.channelConfig.field, new Object[]{this.fromOpenhab(value)}).build();
    }

    @Override
    public void run() {
        this.logger.info("Running task to write field {}", (Object)this.channelConfig.field);
        CompletableFuture execute = this.request.execute();
        try {
            ((CompletableFuture)execute.whenComplete(this::handle)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.warn("Could not write data to PLC", (Throwable)e);
        }
    }

    private void handle(PlcWriteResponse response, Throwable throwable) {
        if (throwable != null) {
            this.logger.info("Could not read field {}, {}", (Object)this.channelConfig.field, (Object)throwable);
            return;
        }
        PlcResponseCode object = response.getResponseCode(this.channelConfig.field);
        switch (object) {
            case OK: {
                this.logger.info("Value {} set to {}", (Object)this.channelConfig.field, (Object)response.getField(this.channelConfig.field));
                break;
            }
            case NOT_FOUND: {
                this.logger.warn("Block {} no found", (Object)this.channelConfig.field);
                break;
            }
            case ACCESS_DENIED: {
                this.logger.warn("Access to field {} denied", (Object)this.channelConfig.field);
                break;
            }
            case INVALID_ADDRESS: {
                this.logger.warn("Invalid address specification {}", (Object)this.channelConfig.field);
                break;
            }
            case INVALID_DATATYPE: {
                this.logger.warn("Wrong data type for field {}", (Object)this.channelConfig.field);
                break;
            }
            case INTERNAL_ERROR: {
                this.logger.warn("Could not process update of {} - internal error", (Object)this.channelConfig.field);
                break;
            }
            case RESPONSE_PENDING: {
                this.logger.warn("Waiting for update of value {}", (Object)this.channelConfig.field);
            }
        }
    }

    private Object fromOpenhab(Command object) {
        if (object instanceof DecimalType) {
            return ((DecimalType)object).toBigDecimal();
        }
        if (object instanceof OnOffType) {
            return object == OnOffType.ON;
        }
        if (object instanceof OpenClosedType) {
            return object == OpenClosedType.OPEN;
        }
        if (object instanceof DateTimeType) {
            return ((DateTimeType)object).getZonedDateTime();
        }
        return object.toString();
    }

    private String getUID() {
        return this.channel.getUID().getAsString();
    }
}

