/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.shared.handler.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.connectorio.binding.plc4x.shared.config.CommonChannelConfiguration;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerCallback;
import org.eclipse.smarthome.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ReadTask.class);
    private final ThingHandlerCallback callback;
    private final PlcReadRequest request;
    private final Channel channel;
    private final CommonChannelConfiguration channelConfig;

    public ReadTask(PlcConnection connection, ThingHandlerCallback callback, Channel channel) {
        this.callback = callback;
        this.channel = channel;
        this.channelConfig = (CommonChannelConfiguration)((Object)channel.getConfiguration().as(CommonChannelConfiguration.class));
        this.request = connection.readRequestBuilder().addItem(this.getUID(), this.channelConfig.field).build();
    }

    @Override
    public void run() {
        this.logger.info("Running task to fetch field {}", (Object)this.channelConfig.field);
        CompletableFuture execute = this.request.execute();
        try {
            ((CompletableFuture)execute.whenComplete(this::handle)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.logger.warn("Could not fetch data from PLC", (Throwable)e);
        }
    }

    private void handle(PlcReadResponse response, Throwable throwable) {
        if (throwable != null) {
            this.logger.info("Could not read field {}, {}", (Object)this.channelConfig.field, (Object)throwable);
            return;
        }
        Object object = response.getObject(this.getUID());
        State state = this.fromPlc(object);
        this.logger.info("Read value {} mapped to {}", object, (Object)state);
        this.callback.stateUpdated(this.channel.getUID(), state);
    }

    private State fromPlc(Object object) {
        if (object instanceof Short) {
            return new DecimalType((long)((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return new DecimalType((long)((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new DecimalType(((Long)object).longValue());
        }
        if (object instanceof Boolean && "Switch".equalsIgnoreCase(this.channel.getAcceptedItemType())) {
            boolean state = (Boolean)object;
            return state ? OnOffType.ON : OnOffType.OFF;
        }
        if (object instanceof Boolean && "Contact".equalsIgnoreCase(this.channel.getAcceptedItemType())) {
            boolean state = (Boolean)object;
            return state ? OpenClosedType.OPEN : OpenClosedType.CLOSED;
        }
        if (object instanceof Double) {
            return new DecimalType(((Double)object).doubleValue());
        }
        if (object instanceof LocalDateTime) {
            return new DateTimeType(((LocalDateTime)object).atZone(ZoneId.systemDefault()));
        }
        if (object instanceof LocalDate) {
            LocalDate date = (LocalDate)object;
            return new DateTimeType(date.atStartOfDay(ZoneId.systemDefault()));
        }
        if (object instanceof LocalTime) {
            LocalTime time = (LocalTime)object;
            return new DateTimeType(time.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()));
        }
        return new StringType(object.toString());
    }

    private String getUID() {
        return this.channel.getUID().getAsString();
    }
}

