/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.shared.handler;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.connectorio.binding.base.config.PollingConfiguration;
import org.connectorio.binding.base.handler.polling.common.BasePollingThingHandler;
import org.connectorio.binding.plc4x.shared.config.CommonChannelConfiguration;
import org.connectorio.binding.plc4x.shared.handler.SharedPlc4xBridgeHandler;
import org.connectorio.binding.plc4x.shared.handler.task.ReadTask;
import org.connectorio.binding.plc4x.shared.handler.task.WriteTask;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SharedPlc4xThingHandler<T extends PlcConnection, B extends SharedPlc4xBridgeHandler<T, ?>, C extends PollingConfiguration>
extends BasePollingThingHandler<B, C>
implements ThingHandler {
    protected final Map<ChannelUID, ScheduledFuture> futures = new ConcurrentHashMap<ChannelUID, ScheduledFuture>();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SharedPlc4xThingHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        this.getBridgeHandler().map(SharedPlc4xBridgeHandler::getInitializer).map(future -> future.whenCompleteAsync(this::connect, (Executor)this.scheduler));
    }

    private void connect(T connection, Throwable e) {
        if (e != null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_UNINITIALIZED);
            return;
        }
        ArrayList<String> configErrors = new ArrayList<String>();
        for (Channel channel : this.thing.getChannels()) {
            ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
            if (channelTypeUID == null) {
                this.logger.warn("Channel {} has no type", (Object)channel.getLabel());
                continue;
            }
            CommonChannelConfiguration channelConfig = (CommonChannelConfiguration)((Object)channel.getConfiguration().as(CommonChannelConfiguration.class));
            try {
                Long cycleTime = channelConfig.refreshInterval == null ? this.getRefreshInterval() : channelConfig.refreshInterval;
                ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(new ReadTask((PlcConnection)connection, this.getCallback(), channel), 0L, cycleTime, TimeUnit.MILLISECONDS);
                this.futures.put(channel.getUID(), future);
            }
            catch (PlcRuntimeException er) {
                this.logger.warn("Channel configuration error", (Throwable)er);
                configErrors.add(channel.getLabel() + ": " + er.getMessage());
            }
        }
        if (!configErrors.isEmpty()) {
            this.clearTasks();
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, "Errors in field configuration: " + configErrors.stream().collect(Collectors.joining(",")));
            return;
        }
        this.updateStatus(ThingStatus.ONLINE);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        Channel channel = this.getThing().getChannel(channelUID);
        if (RefreshType.REFRESH == command) {
            this.getPlcConnection().ifPresent(connection -> this.scheduler.submit(new ReadTask((PlcConnection)connection, this.getCallback(), channel)));
        } else {
            this.getPlcConnection().ifPresent(connection -> this.scheduler.submit(new WriteTask((PlcConnection)connection, channel, command)));
        }
    }

    protected Optional<T> getPlcConnection() {
        return this.getBridgeHandler().map(SharedPlc4xBridgeHandler::getConnection);
    }

    public void dispose() {
        this.clearTasks();
    }

    private void clearTasks() {
        this.futures.forEach((k, v) -> v.cancel(false));
    }
}

