/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.beckhoff.internal.handler;

import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.ads.connection.AdsSerialPlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.connectorio.binding.plc4x.beckhoff.internal.config.BeckhoffSerialConfiguration;
import org.connectorio.binding.plc4x.beckhoff.internal.handler.BeckhoffBridgeHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeckhoffSerialBridgeHandler
extends BeckhoffBridgeHandler<AdsSerialPlcConnection, BeckhoffSerialConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(BeckhoffSerialBridgeHandler.class);

    public BeckhoffSerialBridgeHandler(Bridge thing) {
        super(thing);
    }

    @Override
    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    @Override
    protected Runnable createInitializer(final CompletableFuture<AdsSerialPlcConnection> initializer) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BeckhoffSerialConfiguration config = (BeckhoffSerialConfiguration)((Object)BeckhoffSerialBridgeHandler.this.getBridgeConfig().get());
                    String target = BeckhoffSerialBridgeHandler.this.hostWithPort(config.targetAmsId, config.targetAmsPort);
                    String source = BeckhoffSerialBridgeHandler.this.hostWithPort(config.sourceAmsId, config.sourceAmsPort);
                    AdsSerialPlcConnection connection = (AdsSerialPlcConnection)new PlcDriverManager(this.getClass().getClassLoader()).getConnection("ads:serial://" + config.port + "/" + target + "/" + source);
                    connection.connect();
                    if (connection.isConnected()) {
                        BeckhoffSerialBridgeHandler.this.updateStatus(ThingStatus.ONLINE);
                        initializer.complete(connection);
                    } else {
                        BeckhoffSerialBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Connection failed");
                        initializer.complete(null);
                    }
                }
                catch (PlcConnectionException e) {
                    BeckhoffSerialBridgeHandler.this.logger.warn("Could not obtain connection", (Throwable)e);
                    BeckhoffSerialBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
                    initializer.completeExceptionally(e);
                }
            }
        };
    }
}

