/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.beckhoff.internal.handler;

import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.ads.connection.AdsTcpPlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.connectorio.binding.plc4x.beckhoff.internal.config.BeckhoffNetworkConfiguration;
import org.connectorio.binding.plc4x.beckhoff.internal.handler.BeckhoffBridgeHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeckhoffNetworkBridgeHandler
extends BeckhoffBridgeHandler<AdsTcpPlcConnection, BeckhoffNetworkConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(BeckhoffNetworkBridgeHandler.class);

    public BeckhoffNetworkBridgeHandler(Bridge thing) {
        super(thing);
    }

    @Override
    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    @Override
    protected Runnable createInitializer(final CompletableFuture<AdsTcpPlcConnection> initializer) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BeckhoffNetworkConfiguration config = (BeckhoffNetworkConfiguration)((Object)BeckhoffNetworkBridgeHandler.this.getBridgeConfig().get());
                    String host = BeckhoffNetworkBridgeHandler.this.hostWithPort(config.host, config.port);
                    String target = BeckhoffNetworkBridgeHandler.this.hostWithPort(config.targetAmsId, config.targetAmsPort);
                    String source = config.sourceAmsId != null && config.sourceAmsPort != null ? "/" + BeckhoffNetworkBridgeHandler.this.hostWithPort(config.sourceAmsId, config.sourceAmsPort) : "";
                    AdsTcpPlcConnection connection = (AdsTcpPlcConnection)new PlcDriverManager(this.getClass().getClassLoader()).getConnection("ads:tcp://" + host + "/" + target + source);
                    connection.connect();
                    if (connection.isConnected()) {
                        BeckhoffNetworkBridgeHandler.this.updateStatus(ThingStatus.ONLINE);
                        initializer.complete(connection);
                    } else {
                        BeckhoffNetworkBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, "Connection failed");
                        initializer.complete(null);
                    }
                }
                catch (PlcConnectionException e) {
                    BeckhoffNetworkBridgeHandler.this.logger.warn("Could not obtain connection", (Throwable)e);
                    BeckhoffNetworkBridgeHandler.this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, e.getMessage());
                    initializer.completeExceptionally(e);
                }
            }
        };
    }
}

