/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.beckhoff.internal.handler;

import org.connectorio.binding.plc4x.beckhoff.internal.BeckhoffBindingConstants;
import org.connectorio.binding.plc4x.beckhoff.internal.handler.BeckhoffNetworkBridgeHandler;
import org.connectorio.binding.plc4x.beckhoff.internal.handler.BeckhoffPlcHandler;
import org.connectorio.binding.plc4x.beckhoff.internal.handler.BeckhoffSerialBridgeHandler;
import org.connectorio.binding.plc4x.shared.Plc4xHandlerFactory;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"binding.beckhoff"}, service={ThingHandlerFactory.class})
public class BeckhoffHandlerFactory
extends Plc4xHandlerFactory {
    public BeckhoffHandlerFactory() {
        super(new ThingTypeUID[]{BeckhoffBindingConstants.THING_TYPE_NETWORK, BeckhoffBindingConstants.THING_TYPE_SERIAL, BeckhoffBindingConstants.THING_TYPE_ADS});
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (BeckhoffBindingConstants.THING_TYPE_NETWORK.equals((Object)thingTypeUID)) {
            return new BeckhoffNetworkBridgeHandler((Bridge)thing);
        }
        if (BeckhoffBindingConstants.THING_TYPE_SERIAL.equals((Object)thingTypeUID)) {
            return new BeckhoffSerialBridgeHandler((Bridge)thing);
        }
        if (BeckhoffBindingConstants.THING_TYPE_ADS.equals((Object)thingTypeUID)) {
            return new BeckhoffPlcHandler(thing);
        }
        return null;
    }
}

