/*
 * Decompiled with CFR 0.152.
 */
package org.connectorio.binding.plc4x.beckhoff.internal.handler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.plc4x.java.ads.connection.AdsAbstractPlcConnection;
import org.connectorio.binding.plc4x.beckhoff.internal.BeckhoffBindingConstants;
import org.connectorio.binding.plc4x.beckhoff.internal.config.BeckhoffBridgeConfiguration;
import org.connectorio.binding.plc4x.shared.handler.SharedPlc4xBridgeHandler;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeckhoffBridgeHandler<T extends AdsAbstractPlcConnection, C extends BeckhoffBridgeConfiguration>
extends SharedPlc4xBridgeHandler<T, C> {
    private final Logger logger = LoggerFactory.getLogger(BeckhoffBridgeHandler.class);
    private CompletableFuture<T> initializer;

    public BeckhoffBridgeHandler(Bridge thing) {
        super(thing);
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
    }

    public void initialize() {
        this.updateStatus(ThingStatus.UNKNOWN);
        this.initializer = new CompletableFuture();
        Runnable connectionTask = this.createInitializer(this.initializer);
        this.scheduler.submit(connectionTask);
    }

    public CompletableFuture<T> getInitializer() {
        return this.initializer;
    }

    protected abstract Runnable createInitializer(CompletableFuture<T> var1);

    public T getConnection() {
        try {
            return (T)((AdsAbstractPlcConnection)this.initializer.get(5L, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.warn("Could not obtain connection", (Throwable)e);
            return null;
        }
    }

    protected Long getDefaultPollingInterval() {
        return BeckhoffBindingConstants.DEFAULT_REFRESH_INTERVAL;
    }
}

