/*
 * Decompiled with CFR 0.152.
 */
package org.codegeny.jakartron.jpa;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.codegeny.jakartron.jpa.PersistenceUnitDefinitionEvent;

final class PersistenceUnitInfoBean
implements PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator,
PersistenceUnitInfo {
    private final List<String> classes = new ArrayList<String>();
    private final Properties properties = new Properties();
    private PersistenceUnitTransactionType transactionType;
    private final String unitName;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;

    PersistenceUnitInfoBean(String unitName) {
        this.unitName = unitName;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator classes(Class<?> ... classes) {
        Stream.of(classes).map(Class::getName).forEach(this.classes::add);
        return this;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator classNames(String ... classes) {
        this.classes.addAll(Arrays.asList(classes));
        return this;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator property(String name, String value) {
        this.properties.setProperty(name, value);
        return this;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator transactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator jtaDataSource(DataSource dataSource) {
        this.jtaDataSource = dataSource;
        return this;
    }

    @Override
    public PersistenceUnitDefinitionEvent.PersistenceUnitConfigurator nonJtaDataSource(DataSource dataSource) {
        this.nonJtaDataSource = dataSource;
        return this;
    }

    public String getPersistenceUnitName() {
        return this.unitName;
    }

    public String getPersistenceProviderClassName() {
        return null;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return null;
    }

    public List<URL> getJarFileUrls() {
        return null;
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public List<String> getManagedClassNames() {
        return this.classes;
    }

    public boolean excludeUnlistedClasses() {
        return false;
    }

    public SharedCacheMode getSharedCacheMode() {
        return null;
    }

    public ValidationMode getValidationMode() {
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceXMLSchemaVersion() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void addTransformer(ClassTransformer classTransformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }
}

