/*
 * Decompiled with CFR 0.152.
 */
package org.codegeny.jakartron.jpa;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.literal.InjectLiteral;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceProperty;
import javax.persistence.PersistenceUnit;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.codegeny.jakartron.QualifierInstance;
import org.codegeny.jakartron.jpa.PersistenceUnitDefinition;
import org.codegeny.jakartron.jpa.PersistenceUnitDefinitionEvent;

public final class JPAIntegration
implements Extension {
    private final Set<QualifierInstance<PersistenceUnit>> persistenceUnits = new HashSet<QualifierInstance<PersistenceUnit>>();
    private final Set<QualifierInstance<PersistenceContext>> persistenceContexts = new HashSet<QualifierInstance<PersistenceContext>>();
    private final Set<PersistenceUnitInfo> persistenceUnitInfos = new HashSet<PersistenceUnitInfo>();

    public void addQualifiers(@Observes BeforeBeanDiscovery event) {
        event.addQualifier(PersistenceUnit.class);
        event.configureQualifier(PersistenceContext.class).filterMethods(m -> m.getJavaMember().getReturnType().isArray()).forEach(m -> m.add((Annotation)Nonbinding.Literal.INSTANCE));
    }

    public void defineUnits(@Observes @WithAnnotations(value={PersistenceUnitDefinition.class}) ProcessAnnotatedType<?> event) {
        this.persistenceUnitInfos.add(new PersistenceUnitInfoImpl((PersistenceUnitDefinition)event.getAnnotatedType().getAnnotation(PersistenceUnitDefinition.class)));
    }

    public void makeInjectable(@Observes @WithAnnotations(value={PersistenceUnit.class, PersistenceContext.class}) ProcessAnnotatedType<?> event, BeanManager beanManager) {
        event.configureAnnotatedType().filterFields(f -> f.isAnnotationPresent(PersistenceUnit.class) || f.isAnnotationPresent(PersistenceContext.class)).forEach(f -> this.makeInjectable((AnnotatedFieldConfigurator<?>)f, beanManager));
    }

    public void registerAlternative(@Observes @Priority(value=50) AfterTypeDiscovery event) {
        event.getAlternatives().add(0, this.getClass());
    }

    private void makeInjectable(AnnotatedFieldConfigurator<?> fieldConfigurator, BeanManager beanManager) {
        PersistenceContext persistenceContext = (PersistenceContext)fieldConfigurator.getAnnotated().getAnnotation(PersistenceContext.class);
        PersistenceUnit persistenceUnit = (PersistenceUnit)fieldConfigurator.getAnnotated().getAnnotation(PersistenceUnit.class);
        if (persistenceContext != null) {
            this.persistenceContexts.add((QualifierInstance<PersistenceContext>)new QualifierInstance((Annotation)persistenceContext, beanManager));
            persistenceUnit = new PersistenceUnitLiteral(persistenceContext);
        }
        this.persistenceUnits.add((QualifierInstance<PersistenceUnit>)new QualifierInstance((Annotation)persistenceUnit, beanManager));
        fieldConfigurator.add((Annotation)InjectLiteral.INSTANCE);
    }

    public void addBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.persistenceUnits.forEach(persistenceUnit -> this.addPersistenceUnit((PersistenceUnit)persistenceUnit.getQualifier(), event, beanManager));
        this.persistenceContexts.forEach(persistenceContext -> this.addPersistenceContext((PersistenceContext)persistenceContext.getQualifier(), event));
    }

    public void fireConfigurationEvent(@Observes @Priority(value=100) AfterDeploymentValidation event, BeanManager beanManager) {
        beanManager.getEvent().select(PersistenceUnitDefinitionEvent.class, new Annotation[0]).fire(this.persistenceUnitInfos::add);
        this.persistenceUnits.stream().filter(q -> !((EntityManagerFactory)beanManager.createInstance().select(EntityManagerFactory.class, new Annotation[]{q.getQualifier()}).get()).isOpen()).forEach(q -> event.addDeploymentProblem((Throwable)new Exception("Cannot initialize EntityManagerFactory " + q.getQualifier())));
    }

    private void addPersistenceUnit(PersistenceUnit persistenceUnit, AfterBeanDiscovery event, BeanManager beanManager) {
        event.addBean().alternative(true).createWith(context -> this.createEntityManagerFactory(persistenceUnit, beanManager)).destroyWith((entityManagerFactory, context) -> entityManagerFactory.close()).scope(ApplicationScoped.class).types(new Type[]{Object.class, EntityManagerFactory.class}).qualifiers(new Annotation[]{persistenceUnit, Any.Literal.INSTANCE});
    }

    private EntityManagerFactory createEntityManagerFactory(PersistenceUnit persistenceUnit, BeanManager beanManager) {
        Map<String, BeanManager> map = Collections.singletonMap("javax.persistence.bean.manager", beanManager);
        return Stream.concat(beanManager.createInstance().select(PersistenceUnitInfo.class, new Annotation[0]).stream(), this.persistenceUnitInfos.stream()).filter(i -> i.getPersistenceUnitName().equals(persistenceUnit.unitName())).findFirst().map(unitInfo -> ((PersistenceProvider)PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders().stream().findFirst().orElseThrow(IllegalStateException::new)).createContainerEntityManagerFactory(unitInfo, map)).orElseGet(() -> Persistence.createEntityManagerFactory((String)persistenceUnit.unitName(), (Map)map));
    }

    private void addPersistenceContext(PersistenceContext persistenceContext, AfterBeanDiscovery event) {
        Map<String, String> properties = Stream.of(persistenceContext.properties()).collect(Collectors.toMap(PersistenceProperty::name, PersistenceProperty::value));
        event.addBean().alternative(true).produceWith(instance -> ((EntityManagerFactory)instance.select(EntityManagerFactory.class, new Annotation[]{new PersistenceUnitLiteral(persistenceContext)}).get()).createEntityManager(properties)).disposeWith((entityManager, instance) -> entityManager.close()).scope(JPAIntegration.toScope(persistenceContext.type())).types(new Type[]{Object.class, EntityManager.class}).qualifiers(new Annotation[]{persistenceContext, Any.Literal.INSTANCE});
    }

    private static Class<? extends Annotation> toScope(PersistenceContextType type) {
        switch (type) {
            case TRANSACTION: {
                return RequestScoped.class;
            }
            case EXTENDED: {
                return Dependent.class;
            }
        }
        throw new InternalError();
    }

    static final class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final PersistenceUnitDefinition definition;

        PersistenceUnitInfoImpl(PersistenceUnitDefinition definition) {
            this.definition = definition;
        }

        public String getPersistenceUnitName() {
            return this.definition.unitName();
        }

        public String getPersistenceProviderClassName() {
            return this.definition.providerClassName().isEmpty() ? null : this.definition.providerClassName();
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.definition.transactionType();
        }

        public DataSource getJtaDataSource() {
            return this.dataSource(this.definition.jtaDataSourceName());
        }

        public DataSource getNonJtaDataSource() {
            return this.dataSource(this.definition.nonJtaDataSourceName());
        }

        public List<String> getMappingFileNames() {
            return Arrays.asList(this.definition.mappingFileNames());
        }

        public List<URL> getJarFileUrls() {
            return Stream.of(this.definition.jarFileUrls()).map(this::newURL).collect(Collectors.toList());
        }

        public URL getPersistenceUnitRootUrl() {
            return this.definition.unitRootUrl().isEmpty() ? null : this.newURL(this.definition.unitRootUrl());
        }

        public List<String> getManagedClassNames() {
            return Stream.concat(Stream.of(this.definition.managedClasses()).map(Class::getName), Stream.of(this.definition.managedClassNames())).collect(Collectors.toList());
        }

        public boolean excludeUnlistedClasses() {
            return this.definition.excludeUnlistedClasses();
        }

        public SharedCacheMode getSharedCacheMode() {
            return this.definition.sharedCacheMode();
        }

        public ValidationMode getValidationMode() {
            return this.definition.validationMode();
        }

        public Properties getProperties() {
            Properties properties = new Properties();
            Stream.of(this.definition.properties()).forEach(property -> properties.setProperty(property.name(), property.value()));
            return properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return this.definition.xmlSchemaVersion();
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }

        private URL newURL(String url) {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DataSource dataSource(String name) {
            DataSource dataSource;
            if (name.isEmpty()) {
                return null;
            }
            InitialContext context = new InitialContext();
            try {
                dataSource = (DataSource)context.lookup(name);
            }
            catch (Throwable throwable) {
                try {
                    context.close();
                    throw throwable;
                }
                catch (NamingException namingException) {
                    throw new IllegalStateException("Problem looking up datasource " + name, namingException);
                }
            }
            context.close();
            return dataSource;
        }
    }

    static class PersistenceUnitLiteral
    extends AnnotationLiteral<PersistenceUnit>
    implements PersistenceUnit {
        private static final long serialVersionUID = 8606223218533756791L;
        private final String name;
        private final String unitName;

        PersistenceUnitLiteral(PersistenceContext persistenceContext) {
            this.name = persistenceContext.name();
            this.unitName = persistenceContext.unitName();
        }

        public String name() {
            return this.name;
        }

        public String unitName() {
            return this.unitName;
        }
    }
}

