/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.tool;

import java.io.BufferedReader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JdkInternalsExecutor {
    private final Path jDepsExecutable;
    private final Path pathToCheckedFiles;
    private final Consumer<String> jDepsOutputConsumer;

    public JdkInternalsExecutor(Path jDepsExecutable, Path folderToScan, Consumer<String> jDepsOutputConsumer) {
        Objects.requireNonNull(jDepsExecutable, "The argument 'jDepsExecutable' must not be null.");
        Objects.requireNonNull(folderToScan, "The argument 'pathToCheckedFiles' must not be null.");
        Objects.requireNonNull(jDepsOutputConsumer, "The argument 'jDepsOutputConsumer' must not be null.");
        this.jDepsExecutable = jDepsExecutable;
        this.pathToCheckedFiles = folderToScan;
        this.jDepsOutputConsumer = jDepsOutputConsumer;
    }

    public void execute() throws CommandLineException {
        Commandline jDepsCommand = this.createJDepsCommand(this.jDepsExecutable);
        this.execute(jDepsCommand);
    }

    private Commandline createJDepsCommand(Path jDepsExecutable) {
        Commandline jDepsCommand = new Commandline();
        jDepsCommand.setExecutable(jDepsExecutable.toAbsolutePath().toString());
        jDepsCommand.createArg().setValue("-jdkinternals");
        jDepsCommand.createArg().setFile(this.pathToCheckedFiles.toFile());
        return jDepsCommand;
    }

    private void execute(Commandline jDepsCommand) throws CommandLineException {
        CommandLineUtils.StringStreamConsumer errorConsoleConsumer = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)jDepsCommand, this.jDepsOutputConsumer::accept, (StreamConsumer)errorConsoleConsumer);
        if (exitCode != 0) {
            JdkInternalsExecutor.throwCommandLineException(jDepsCommand, exitCode, errorConsoleConsumer.getOutput());
        }
    }

    private static void throwCommandLineException(Commandline jDepsCommand, int exitCode, String errorOutput) throws CommandLineException {
        StringBuilder message = new StringBuilder("JDeps returned with exit code '" + exitCode + "'.\n");
        message.append("\t Executed command: " + CommandLineUtils.toString((String[])jDepsCommand.getCommandline()).replaceAll("'", ""));
        message.append("\t Error output:\n");
        JdkInternalsExecutor.streamLines(errorOutput).forEachOrdered(errorLine -> message.append("\t\t " + errorLine + "\n"));
        throw new CommandLineException(message.toString());
    }

    private static Stream<String> streamLines(String lines) {
        return new BufferedReader(new StringReader(lines)).lines();
    }
}

