/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.tool;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.codefx.maven.plugin.jdeps.tool.JDepsSearch;
import org.codefx.maven.plugin.jdeps.tool.SearchJDepsInJdk;

class JavaHomeEnvironmentVariableJDepsSearch
implements JDepsSearch {
    private final SearchJDepsInJdk searchJDepsInJdk;

    public JavaHomeEnvironmentVariableJDepsSearch() {
        this(new SearchJDepsInJdk());
    }

    public JavaHomeEnvironmentVariableJDepsSearch(SearchJDepsInJdk searchJDepsInJdk) {
        this.searchJDepsInJdk = searchJDepsInJdk;
    }

    @Override
    public Optional<Path> search() {
        Optional<Path> javaHome = JavaHomeEnvironmentVariableJDepsSearch.getJavaHome();
        if (!javaHome.isPresent()) {
            return Optional.empty();
        }
        return this.searchJDepsInJdk.search(javaHome.get());
    }

    private static Optional<Path> getJavaHome() {
        try {
            String javaHome = System.getenv("JAVA_HOME");
            if (StringUtils.isEmpty((CharSequence)javaHome)) {
                return Optional.empty();
            }
            return Optional.of(Paths.get(javaHome, new String[0]));
        }
        catch (SecurityException ex) {
            return Optional.empty();
        }
    }
}

