/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.parse;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codefx.maven.plugin.jdeps.dependency.InternalType;
import org.codefx.maven.plugin.jdeps.dependency.Type;
import org.codefx.maven.plugin.jdeps.dependency.Violation;
import org.codefx.maven.plugin.jdeps.parse.InternalTypeLineParser;

public class ViolationParser {
    private static final Pattern REPORTED_TYPE_PATTERN = Pattern.compile("\\s+([a-zA_Z_][\\.\\w]*)\\s+.*");
    private final InternalTypeLineParser internalTypeLineParser;
    private final Consumer<Violation> violationConsumer;
    private LineParserState lineParser;

    public ViolationParser(Consumer<Violation> violationConsumer) {
        this(new InternalTypeLineParser(), violationConsumer);
    }

    public ViolationParser(InternalTypeLineParser internalTypeLineParser, Consumer<Violation> violationConsumer) {
        Objects.requireNonNull(internalTypeLineParser, "The argument 'internalTypeLineParser' must not be null.");
        Objects.requireNonNull(violationConsumer, "The argument 'violationConsumer' must not be null.");
        this.internalTypeLineParser = internalTypeLineParser;
        this.violationConsumer = violationConsumer;
        this.lineParser = new NoBlock();
    }

    public void parseLine(String line) {
        Objects.requireNonNull(line, "The argument 'line' must not be null.");
        this.lineParser = this.lineParser.parseLine(line);
    }

    public void finish() {
        this.lineParser = this.lineParser.parseLine("");
    }

    private LineParserState determineWhetherNewBlockStarted(String line) {
        Optional<String> asFirstBlockLine = ViolationParser.parseAsFirstBlockLine(line);
        if (asFirstBlockLine.isPresent()) {
            return new BlockBegan(asFirstBlockLine.get());
        }
        return new NoBlock();
    }

    private static Optional<String> parseAsFirstBlockLine(String line) {
        Matcher firstLineMatcher = REPORTED_TYPE_PATTERN.matcher(line);
        boolean isFirstLine = firstLineMatcher.matches();
        if (isFirstLine) {
            return Optional.of(firstLineMatcher.group(1));
        }
        return Optional.empty();
    }

    private class BlockBegan
    implements LineParserState {
        private final Violation.ViolationBuilder violationBuilder;

        public BlockBegan(String fullyQualifiedClassName) {
            assert (fullyQualifiedClassName != null) : "The argument 'fullyQualifiedClassName' must not be null.";
            Type type = Type.of(fullyQualifiedClassName);
            this.violationBuilder = Violation.forType(type);
        }

        @Override
        public LineParserState parseLine(String line) {
            assert (line != null) : "The argument 'line' must not be null.";
            boolean lineCouldBeProcessed = this.processLine(line);
            return this.computeNextState(line, lineCouldBeProcessed);
        }

        private boolean processLine(String line) {
            Optional<InternalType> parsedInternalType = ViolationParser.this.internalTypeLineParser.parseLine(line);
            parsedInternalType.ifPresent(this.violationBuilder::addDependency);
            return parsedInternalType.isPresent();
        }

        private LineParserState computeNextState(String line, boolean lineCouldBeProcessed) {
            if (lineCouldBeProcessed) {
                return this;
            }
            this.finishViolation();
            return ViolationParser.this.determineWhetherNewBlockStarted(line);
        }

        private void finishViolation() {
            Violation violation = this.violationBuilder.build();
            ViolationParser.this.violationConsumer.accept(violation);
        }
    }

    private class NoBlock
    implements LineParserState {
        private NoBlock() {
        }

        @Override
        public LineParserState parseLine(String line) {
            return ViolationParser.this.determineWhetherNewBlockStarted(line);
        }
    }

    private static interface LineParserState {
        public LineParserState parseLine(String var1);
    }
}

