/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.parse;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codefx.maven.plugin.jdeps.dependency.InternalType;

public class InternalTypeLineParser {
    private static final Pattern JDEPS_DEPENDENCY_PATTERN = Pattern.compile("\\s+->\\s+([a-zA_Z_][\\.\\w]*)\\s+(\\w[\\w\\s]*\\w*)\\s\\(([\\w\\.]*)\\).*");

    public boolean isInternalTypeLine(String line) {
        Objects.requireNonNull(line, "The argument 'line' must not be null.");
        return JDEPS_DEPENDENCY_PATTERN.matcher(line).matches();
    }

    public Optional<InternalType> parseLine(String line) {
        Objects.requireNonNull(line, "The argument 'line' must not be null.");
        Matcher lineMatcher = JDEPS_DEPENDENCY_PATTERN.matcher(line);
        if (!lineMatcher.matches() || lineMatcher.groupCount() != 3) {
            return Optional.empty();
        }
        String fullyQualifiedClassName = lineMatcher.group(1);
        String category = lineMatcher.group(2);
        String source = lineMatcher.group(3);
        InternalType type = InternalType.of(InternalTypeLineParser.extractPackageName(fullyQualifiedClassName), InternalTypeLineParser.extractClassName(fullyQualifiedClassName), category, source);
        return Optional.of(type);
    }

    private static String extractPackageName(String fullyQualifiedClassName) {
        int indexOfLastPoint = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(0, indexOfLastPoint);
    }

    private static String extractClassName(String fullyQualifiedClassName) {
        int indexOfLastPoint = fullyQualifiedClassName.lastIndexOf(46);
        return fullyQualifiedClassName.substring(indexOfLastPoint + 1);
    }
}

