/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.mojo;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codefx.maven.plugin.jdeps.dependency.Violation;
import org.codefx.maven.plugin.jdeps.mojo.JdkInternalsExecutionService;
import org.codehaus.plexus.util.cli.CommandLineException;

@Mojo(name="jdkinternals", threadSafe=true, requiresProject=true, defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE)
public class JdkInternalsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ImmutableList<Violation> violations = this.executeJDeps();
        JdkInternalsMojo.evaluateViolations(violations);
    }

    private ImmutableList<Violation> executeJDeps() throws MojoFailureException {
        try {
            return JdkInternalsExecutionService.execute(this.outputDirectory);
        }
        catch (CommandLineException ex) {
            throw new MojoFailureException("Executing 'jdeps -jdkinternals' failed.", (Throwable)ex);
        }
    }

    private static void evaluateViolations(ImmutableList<Violation> violations) throws MojoExecutionException {
        if (violations.isEmpty()) {
            return;
        }
        String message = violations.stream().map(Violation::toMultiLineString).collect(Collectors.joining("\n", "\nSome classes contain dependencies on JDK-internal API:\n", "\n\n"));
        throw new MojoExecutionException(message);
    }
}

