/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.mojo;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.codefx.maven.plugin.jdeps.dependency.Violation;
import org.codefx.maven.plugin.jdeps.parse.ViolationParser;
import org.codefx.maven.plugin.jdeps.tool.ComposedJDepsSearch;
import org.codefx.maven.plugin.jdeps.tool.JdkInternalsExecutor;
import org.codehaus.plexus.util.cli.CommandLineException;

public class JdkInternalsExecutionService {
    public static ImmutableList<Violation> execute(File scannedFolder) throws CommandLineException {
        Path jDepsExecutable = JdkInternalsExecutionService.findJDepsExecutable();
        ImmutableList.Builder violationListBuilder = ImmutableList.builder();
        ViolationParser violationParser = new ViolationParser(arg_0 -> ((ImmutableList.Builder)violationListBuilder).add(arg_0));
        JdkInternalsExecutor executor = new JdkInternalsExecutor(jDepsExecutable, Paths.get(scannedFolder.toURI()), violationParser::parseLine);
        executor.execute();
        return violationListBuilder.build();
    }

    private static Path findJDepsExecutable() throws CommandLineException {
        ComposedJDepsSearch jDepsSearch = new ComposedJDepsSearch();
        return jDepsSearch.search().orElseThrow(() -> new CommandLineException("Could not locate jdeps executable."));
    }
}

