/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.dependency;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.codefx.maven.plugin.jdeps.dependency.InternalType;
import org.codefx.maven.plugin.jdeps.dependency.Type;

public class Violation {
    private final Type type;
    private final ImmutableList<InternalType> internalDependencies;

    private Violation(Type type, ImmutableList<InternalType> internalDependencies) {
        Objects.requireNonNull(type, "The argument 'type' must not be null.");
        Objects.requireNonNull(internalDependencies, "The argument 'internalDependencies' must not be null.");
        if (internalDependencies.size() == 0) {
            throw new IllegalArgumentException("A violation must contain at least one internal dependency.");
        }
        this.type = type;
        this.internalDependencies = internalDependencies;
    }

    public static ViolationBuilder forType(Type type) {
        return new ViolationBuilder(type);
    }

    public Type getType() {
        return this.type;
    }

    public ImmutableList<InternalType> getInternalDependencies() {
        return this.internalDependencies;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Violation other = (Violation)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.internalDependencies, other.internalDependencies);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.type);
        result = 31 * result + Objects.hashCode(this.internalDependencies);
        return result;
    }

    public String toString() {
        String dependencies = this.internalDependencies.stream().map(Object::toString).collect(Collectors.joining(", ", "{", "}"));
        return this.type + " -> " + dependencies;
    }

    public String toMultiLineString() {
        String typeLine = ".\t" + this.type + "\n";
        String dependencyLineStart = ".\t\t -> ";
        return typeLine + this.internalDependencies.stream().map(Object::toString).collect(Collectors.joining("\n" + dependencyLineStart, dependencyLineStart, ""));
    }

    public static class ViolationBuilder {
        private final Type type;
        private final ImmutableList.Builder<InternalType> internalDependenciesBuilder;

        private ViolationBuilder(Type type) {
            this.type = type;
            this.internalDependenciesBuilder = ImmutableList.builder();
        }

        public void addDependency(InternalType dependency) {
            this.internalDependenciesBuilder.add((Object)dependency);
        }

        public Violation build() {
            return new Violation(this.type, this.internalDependenciesBuilder.build());
        }
    }
}

