/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.maven.plugin.jdeps.dependency;

import java.util.Objects;

public class Type {
    private final String packageName;
    private final String className;

    protected Type(String packageName, String className) {
        Objects.requireNonNull(packageName, "The argument 'packageName' must not be null.");
        Objects.requireNonNull(className, "The argument 'className' must not be null.");
        this.packageName = packageName;
        this.className = className;
    }

    public static Type of(String packageName, String className) {
        return new Type(packageName, className);
    }

    public static Type of(String qualifiedClassName) {
        Objects.requireNonNull(qualifiedClassName, "The argument 'qualifiedClassName' must not be null.");
        int lastDotIndex = qualifiedClassName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("The argument 'qualifiedClassName' must be a fully qualified class name with at least one dot ('.').");
        }
        String packageName = qualifiedClassName.substring(0, lastDotIndex);
        String className = qualifiedClassName.substring(lastDotIndex + 1);
        return new Type(packageName, className);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        return Objects.equals(this.packageName, other.packageName) && Objects.equals(this.className, other.className);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hash(this.packageName);
        result = 31 * result + Objects.hash(this.className);
        return result;
    }

    public String toString() {
        return this.packageName + "." + this.className;
    }
}

