/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting.property;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.property.InnerObservableMissingBehavior;
import org.codefx.libfx.nesting.property.NestedProperty;

final class NestedPropertyInternals<T> {
    private final Nesting<? extends Property<T>> nesting;
    private final NestedProperty<T> outerProperty;
    private final Consumer<? super T> setValueDirectly;
    private final InnerObservableMissingBehavior<? extends T> missingBehavior;
    private final BooleanProperty innerObservablePresent;

    public NestedPropertyInternals(NestedProperty<T> outerProperty, Nesting<? extends Property<T>> nesting, InnerObservableMissingBehavior<? extends T> missingBehavior, Consumer<? super T> setValueDirectly) {
        assert (nesting != null) : "The argument 'nesting' must not be null.";
        assert (outerProperty != null) : "The argument 'outerProperty' must not be null.";
        assert (setValueDirectly != null) : "The argument 'setValueDirectly' must not be null.";
        assert (missingBehavior != null) : "The argument 'missingBehavior' must not be null.";
        assert (missingBehavior.whenGoesMissing() != InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.SET_VALUE_FROM_SUPPLIER || missingBehavior.valueForMissing().isPresent()) : "When 'missingBehavior' requests 'SET_VALUE_FROM_SUPPLIER', a supplier must be present.";
        this.nesting = nesting;
        this.outerProperty = outerProperty;
        this.setValueDirectly = setValueDirectly;
        this.innerObservablePresent = new SimpleBooleanProperty(outerProperty, "innerObservablePresent");
        this.missingBehavior = missingBehavior;
    }

    public void initializeBinding() {
        this.bindToInnerObservable((Optional)this.nesting.innerObservableProperty().getValue());
        this.nesting.innerObservableProperty().addListener((obs, oldInnerObservable, newInnerObservable) -> this.moveBindingToNewInnerObservable((Optional<? extends Property<T>>)oldInnerObservable, (Optional<? extends Property<T>>)newInnerObservable));
    }

    private void moveBindingToNewInnerObservable(Optional<? extends Property<T>> oldInnerObservable, Optional<? extends Property<T>> newInnerObservable) {
        this.unbindFromInnerObservable(oldInnerObservable);
        this.bindToInnerObservable(newInnerObservable);
    }

    private void unbindFromInnerObservable(Optional<? extends Property<T>> innerObservable) {
        innerObservable.ifPresent(arg_0 -> this.outerProperty.unbindBidirectional(arg_0));
    }

    private void bindToInnerObservable(Optional<? extends Property<T>> innerObservable) {
        this.innerObservablePresent.set(innerObservable.isPresent());
        if (!innerObservable.isPresent()) {
            this.handleMissingInnerObservable();
        }
        innerObservable.ifPresent(arg_0 -> this.outerProperty.bindBidirectional(arg_0));
    }

    private void handleMissingInnerObservable() {
        InnerObservableMissingBehavior.WhenInnerObservableGoesMissing whenGoesMissing = this.missingBehavior.whenGoesMissing();
        switch (whenGoesMissing) {
            case KEEP_VALUE: {
                return;
            }
            case SET_DEFAULT_VALUE: {
                this.setDefaultValueIgnoringMissingInnerObservable();
                return;
            }
            case SET_VALUE_FROM_SUPPLIER: {
                Supplier<T> supplierForMissingValue = this.missingBehavior.valueForMissing().get();
                this.setIgnoringMissingInnerObservable(supplierForMissingValue.get());
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedere for missing inner observable: " + (Object)((Object)whenGoesMissing));
    }

    private void set(T newValue, boolean checkMissingInnerObservable) {
        if (checkMissingInnerObservable) {
            this.maybeThrowExceptionForMissingObservable();
        }
        this.setValueDirectly.accept(newValue);
    }

    private void maybeThrowExceptionForMissingObservable() {
        boolean throwExceptionConfigured;
        boolean innerObservableMissing = !this.innerObservablePresent.get();
        boolean bl = throwExceptionConfigured = this.missingBehavior.onUpdate() == InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate.THROW_EXCEPTION;
        if (innerObservableMissing && throwExceptionConfigured) {
            throw new IllegalStateException("The inner observable is missing so no value can be set.");
        }
    }

    public void setCheckingMissingInnerObservable(T newValue) {
        this.set(newValue, true);
    }

    private void setIgnoringMissingInnerObservable(T newValue) {
        this.set(newValue, false);
    }

    private void setDefaultValueIgnoringMissingInnerObservable() {
        this.set(null, false);
    }

    public final ReadOnlyBooleanProperty innerObservablePresentProperty() {
        return this.innerObservablePresent;
    }
}

