/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting.property;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javafx.beans.property.Property;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.property.InnerObservableMissingBehavior;
import org.codefx.libfx.nesting.property.NestedProperty;

abstract class AbstractNestedPropertyBuilder<T, O extends Property<?>, P extends NestedProperty<?>, B extends AbstractNestedPropertyBuilder<T, O, P, B>> {
    private final Nesting<O> nesting;
    private final MutableInnerObservableMissingBehavior<T> innerObservableMissingBehavior;
    private Object bean;
    private String name;

    protected AbstractNestedPropertyBuilder(Nesting<O> nesting) {
        Objects.requireNonNull(nesting, "The argument 'nesting' must not be null.");
        this.nesting = nesting;
        this.innerObservableMissingBehavior = new MutableInnerObservableMissingBehavior();
    }

    public abstract P build();

    public final B setBean(Object bean) {
        Objects.requireNonNull(bean, "The argument 'bean' must not be null.");
        this.bean = bean;
        return this.thisAsB();
    }

    public B setName(String name) {
        Objects.requireNonNull(name, "The argument 'name' must not be null.");
        this.name = name;
        return this.thisAsB();
    }

    public B onInnerObservableMissingKeepValue() {
        this.innerObservableMissingBehavior.whenGoesMissing(InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.KEEP_VALUE);
        return this.thisAsB();
    }

    public B onInnerObservableMissingSetDefaultValue() {
        this.innerObservableMissingBehavior.whenGoesMissing(InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.SET_DEFAULT_VALUE);
        return this.thisAsB();
    }

    public B onInnerObservableMissingSetValue(T value) {
        Objects.requireNonNull(value, "The argument 'value' must not be null.");
        this.innerObservableMissingBehavior.whenGoesMissing(InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.SET_VALUE_FROM_SUPPLIER);
        this.innerObservableMissingBehavior.valueForMissing(() -> value);
        return this.thisAsB();
    }

    public B onInnerObservableMissingComputeValue(Supplier<T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "The argument 'valueSupplier' must not be null.");
        this.innerObservableMissingBehavior.whenGoesMissing(InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.SET_VALUE_FROM_SUPPLIER);
        this.innerObservableMissingBehavior.valueForMissing(valueSupplier);
        return this.thisAsB();
    }

    public B onUpdateWhenInnerObservableMissingThrowException() {
        this.innerObservableMissingBehavior.onUpdate(InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate.THROW_EXCEPTION);
        return this.thisAsB();
    }

    public B onUpdateWhenInnerObservableMissingAcceptValues() {
        this.innerObservableMissingBehavior.onUpdate(InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate.ACCEPT_VALUE_UNTIL_NEXT_INNER_OBSERVABLE);
        return this.thisAsB();
    }

    private B thisAsB() {
        AbstractNestedPropertyBuilder thisAsB = this;
        return (B)thisAsB;
    }

    protected final Nesting<O> getNesting() {
        return this.nesting;
    }

    protected final Object getBean() {
        return this.bean;
    }

    protected final String getName() {
        return this.name;
    }

    protected final InnerObservableMissingBehavior<T> getInnerObservableMissingBehavior() {
        return new ImmutableInnerObservableMissingBehavior<T>(this.innerObservableMissingBehavior);
    }

    private static class ImmutableInnerObservableMissingBehavior<T>
    implements InnerObservableMissingBehavior<T> {
        private final InnerObservableMissingBehavior.WhenInnerObservableGoesMissing whenGoesMissing;
        private final Optional<? extends Supplier<T>> valueForMissing;
        private final InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate onUpdate;

        public ImmutableInnerObservableMissingBehavior(MutableInnerObservableMissingBehavior<T> behavior) {
            this.whenGoesMissing = ((MutableInnerObservableMissingBehavior)behavior).whenGoesMissing;
            this.valueForMissing = ((MutableInnerObservableMissingBehavior)behavior).valueForMissing;
            this.onUpdate = ((MutableInnerObservableMissingBehavior)behavior).onUpdate;
        }

        @Override
        public InnerObservableMissingBehavior.WhenInnerObservableGoesMissing whenGoesMissing() {
            return this.whenGoesMissing;
        }

        @Override
        public Optional<? extends Supplier<T>> valueForMissing() {
            return this.valueForMissing;
        }

        @Override
        public InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate onUpdate() {
            return this.onUpdate;
        }
    }

    private static class MutableInnerObservableMissingBehavior<T> {
        private static final InnerObservableMissingBehavior.WhenInnerObservableGoesMissing DEFAULT_WHEN_GOES_MISSING = InnerObservableMissingBehavior.WhenInnerObservableGoesMissing.KEEP_VALUE;
        private static final InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate DEFAULT_ON_UPDATE = InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate.THROW_EXCEPTION;
        private InnerObservableMissingBehavior.WhenInnerObservableGoesMissing whenGoesMissing = DEFAULT_WHEN_GOES_MISSING;
        private Optional<? extends Supplier<T>> valueForMissing = Optional.empty();
        private InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate onUpdate = DEFAULT_ON_UPDATE;

        public void whenGoesMissing(InnerObservableMissingBehavior.WhenInnerObservableGoesMissing whenGoesMissing) {
            assert (whenGoesMissing != null) : "The argument 'whenGoesMissing' must not be null.";
            this.whenGoesMissing = whenGoesMissing;
        }

        public void valueForMissing(Supplier<T> valueForMissing) {
            this.valueForMissing = Optional.of(valueForMissing);
        }

        public void onUpdate(InnerObservableMissingBehavior.WhenInnerObservableMissingOnUpdate onUpdate) {
            assert (onUpdate != null) : "The argument 'onUpdate' must not be null.";
            this.onUpdate = onUpdate;
        }
    }
}

