/*
 * Decompiled with CFR 0.152.
 */
package org.codefx.libfx.nesting.listener;

import java.util.Objects;
import javafx.beans.InvalidationListener;
import org.codefx.libfx.nesting.Nesting;
import org.codefx.libfx.nesting.listener.NestedInvalidationListenerHandle;

public class NestedInvalidationListenerBuilder {
    private final Nesting<?> nesting;
    private InvalidationListener listener;

    private NestedInvalidationListenerBuilder(Nesting<?> nesting) {
        Objects.requireNonNull(nesting, "The argument 'nesting' must not be null.");
        this.nesting = nesting;
    }

    private NestedInvalidationListenerBuilder(NestedInvalidationListenerBuilder other) {
        Objects.requireNonNull(other, "The argument 'other' must not be null.");
        this.nesting = other.nesting;
    }

    public static NestedInvalidationListenerBuilder forNesting(Nesting<?> nesting) {
        return new NestedInvalidationListenerBuilder(nesting);
    }

    public Buildable withListener(InvalidationListener listener) {
        Objects.requireNonNull(listener, "The argument 'listener' must not be null.");
        this.listener = listener;
        return new Buildable(this);
    }

    public class Buildable
    extends NestedInvalidationListenerBuilder {
        private boolean built;

        private Buildable(NestedInvalidationListenerBuilder builder) {
            super(builder);
        }

        public NestedInvalidationListenerHandle buildAttached() {
            NestedInvalidationListenerHandle listenerHandle = this.buildDetached();
            listenerHandle.attach();
            return listenerHandle;
        }

        public NestedInvalidationListenerHandle buildDetached() {
            if (this.built) {
                throw new IllegalStateException("This builder can only build one 'NestedInvalidationListenerHandle'.");
            }
            this.built = true;
            return new NestedInvalidationListenerHandle(NestedInvalidationListenerBuilder.this.nesting, NestedInvalidationListenerBuilder.this.listener);
        }
    }
}

